﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../../precompiled.h"

#include <nw/snd/fnd/binary/sndfnd_PrimitiveTypes.h>
#include <mcs/handler/UpdateAllEventIDHandler.h>
#include <anim/AnimSoundController.h>
#include "Constants.h"

namespace {

// リクエストで送られるデータの構造。
struct PacketData
{
    nw::snd::internal::fnd::BinU32 count;
    nw::snd::internal::fnd::BinU16 idList[1];
};

}

namespace nw {
namespace snd {

//----------------------------------------------------------
void
UpdateAllEventIDHandler::Initialize(AnimSoundController& animSoundController)
{
    m_AnimSoundController = &animSoundController;
}

//----------------------------------------------------------
void
UpdateAllEventIDHandler::OnInvoke(
    const HioMessageHeader& header,
    const void* data,
    nw::ut::IoStream& writeStream)
{
#if defined(NW_DEBUG)
    NW_LOG("[HIO] update all event id.\n");
#endif

    NW_NULL_ASSERT(m_AnimSoundController);

    const PacketData* request = reinterpret_cast<const PacketData*>(data);

    u16 idList[Constants::ANIMEVENT_MAX];
    for (u32 i = 0; i < request->count; ++i)
    {
        if (i >= Constants::ANIMEVENT_MAX)
        {
            break;
        }

        idList[i] = u16(request->idList[i]);
    }

    m_AnimSoundController->UpdateAllEventID(idList, request->count);
}

} // snd
} // nw

