﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../../precompiled.h"

#include <mcs/handler/StopAllHandler.h>
#include <anim/AnimSoundController.h>

namespace nw {
namespace snd {

//----------------------------------------------------------
void
StopAllHandler::Initialize(PreviewSoundArchive& previewSoundArchive, AnimSoundController& animSoundController)
{
    m_PreviewSoundArchive = &previewSoundArchive;
    m_AnimSoundController = &animSoundController;
}

//----------------------------------------------------------
void
StopAllHandler::OnInvoke(
    const HioMessageHeader& header,
    const void* data,
    nw::ut::IoStream& writeStream)
{
#if defined(NW_DEBUG)
    NW_LOG("StopAllHandler\n");
#endif

    NW_NULL_ASSERT(m_PreviewSoundArchive);
    NW_NULL_ASSERT(m_AnimSoundController);

    for(s32 i=0; i<m_PreviewSoundArchive->GetPreviewSoundCount(); ++i)
    {
        m_PreviewSoundArchive->GetPreviewSound(i).Stop();
    }

    m_AnimSoundController->StopAll();
}

} // snd
} // nw
