﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../../precompiled.h"

#include <nw/snd/fnd/binary/sndfnd_PrimitiveTypes.h>
#include <mcs/handler/SetAnimationRangeHandler.h>
#include <anim/GfxCoordinator.h>

namespace nw {
namespace snd {

//----------------------------------------------------------
void
SetAnimationRangeHandler::OnInvoke(
    const HioMessageHeader& header,
    const void* data,
    nw::ut::IoStream& writeStream)
{
    const internal::fnd::BinF32* range =
        reinterpret_cast<const internal::fnd::BinF32*>(data);

    f32  start = range[0];
    f32  end   = range[1];

#if defined(NW_DEBUG)
    NW_LOG("[HIO] set 3D animation range. (%f - %f)\n", start, end);
#endif

    internal::fnd::BinF32 currentFrame = 0.f;

    if (GfxCoordinator::IsInitialized())
    {
        GfxCoordinator::GetInstance().SetRange(start, end);

        // 設定を変えた後の現在のフレームを返す
        currentFrame = GfxCoordinator::GetInstance().GetFrame();
    }

    // TODO : ★結果コードをヘッダに含める
    HioMessageHeader replyHeader(header.message, sizeof(f32));
    //HioReplyMessageHeader replyHeader(header.message, sizeof(f32));
    //replyHeader.result = HIO_RESULT_SUCCESS;

    writeStream.Write(&replyHeader, sizeof(HioMessageHeader));
    writeStream.Write(&currentFrame, sizeof(f32));

}


} // namespace nw::snd
} // namespace nw
