﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../../precompiled.h"

#include <nw/snd/fnd/binary/sndfnd_PrimitiveTypes.h>
#include <mcs/ItemContainer.h>
#include <mcs/handler/SelectSoundsHandler.h>

namespace
{

typedef struct {
    nw::snd::internal::fnd::BinU32 index;
    unsigned char label[260];
} PacketData;

}

namespace nw {
namespace snd {

//----------------------------------------------------------
void
SelectSoundsHandler::Initialize(PreviewSoundArchive& previewSoundArchive)
{
    m_PreviewSoundArchive = &previewSoundArchive;
}

//----------------------------------------------------------
void
SelectSoundsHandler::OnInvoke(
    const HioMessageHeader& header,
    const void* data,
    nw::ut::IoStream& writeStream)
{
#if defined(NW_DEBUG)
    NW_LOG("SelectSoundsHandler\n");
#endif

    NW_NULL_ASSERT(m_PreviewSoundArchive);
    NW_NULL_ASSERT(data);

    if (!m_PreviewSoundArchive->IsOpened())
    {
        NW_WARNING(false, "SoundArchive not opened.");
        return;
    }

    ItemContainerReader<PacketData> inputItems( reinterpret_cast<const ToolSoundItemContainer*>(data) );

    // コンテナの内容をパラメータに展開する
    while( 1 )
    {
        PacketData* pInputItem = inputItems.Next();
        if(NULL == pInputItem)
        {
            break;
        }

        // PreviewPlayer インデックスチェック
        if(pInputItem->index >= static_cast<u32>(m_PreviewSoundArchive->GetPreviewSoundCount()))
        {
            NW_WARNING(false, "Invalid PreviewPlayer Index : %d\n", pInputItem->index);
            continue;
        }

        m_PreviewSoundArchive->GetPreviewSound(pInputItem->index).SetLabel(
            reinterpret_cast<const char*>(pInputItem->label));
    }
}

} // snd
} // nw
