﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../../precompiled.h"

#include <nw/snd/fnd/binary/sndfnd_PrimitiveTypes.h>
#include <mcs/handler/PauseSoundHandler.h>

namespace nw {
namespace snd {

//----------------------------------------------------------
void
PauseSoundHandler::Initialize(PreviewSoundArchive& previewSoundArchive)
{
    m_PreviewSoundArchive = &previewSoundArchive;
}

//----------------------------------------------------------
void
PauseSoundHandler::OnInvoke(
    const HioMessageHeader& header,
    const void* data,
    nw::ut::IoStream& writeStream)
{
#if defined(NW_DEBUG)
    NW_LOG("PauseSoundHandler\n");
#endif
    NW_NULL_ASSERT(m_PreviewSoundArchive);
    NW_NULL_ASSERT(data);

    internal::fnd::BinU32 index = *(internal::fnd::BinU32*)data;
    m_PreviewSoundArchive->GetPreviewSound(index).Pause();
}

} // snd
} // nw
