﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../../precompiled.h"

#include <mcs/handler/OpenSoundArchiveHandler.h>

namespace nw {
namespace snd {

//----------------------------------------------------------
OpenSoundArchiveHandler::OpenSoundArchiveHandler() :
m_PreviewSoundArchive(NULL)
{
}

//----------------------------------------------------------
void
OpenSoundArchiveHandler::Initialize(PreviewSoundArchive& previewSoundArchive)
{
    m_PreviewSoundArchive = &previewSoundArchive;
}

//----------------------------------------------------------
void
OpenSoundArchiveHandler::OnInvoke(
    const HioMessageHeader& header,
    const void* data,
    nw::ut::IoStream& writeStream)
{
#if defined(NW_DEBUG)
    NW_LOG("OpenSoundArchiveHandler\n");
#endif
    if(m_PreviewSoundArchive == NULL)
    {
        NW_WARNING(false, "OpenSoundArchiveHandler not initialized.");
        return;
    }

    // TODO : ★文字列サイズをパケットに含める
    // TODO : ★フルパスを受け取るようにする
    static const u32 MAX_FILE_PATH = 1024;
    char path[MAX_FILE_PATH];
#if defined(NW_USE_NINTENDO_SDK)
    ut::snprintf(path, MAX_FILE_PATH, "content:/%s", reinterpret_cast<const char*>(data));
#else
    ut::snprintf(path, MAX_FILE_PATH, "/vol/content/%s", reinterpret_cast<const char*>(data));
#endif

    m_PreviewSoundArchive->Open(path);

    Reply(writeStream, HIO_RESULT_SUCCESS);
}

//----------------------------------------------------------
void
OpenSoundArchiveHandler::Reply(nw::ut::IoStream& writeStream, HioResult result)
{
    HioReplyMessageHeader replyHeader(
        HIO_MESSAGE_OPEN_SOUNDARCHIVE,
        sizeof(u32));
    replyHeader.result = result;

    writeStream.Write(&replyHeader, sizeof(HioReplyMessageHeader));
}


} // namespace nw::snd
} // namespace nw
