﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../../precompiled.h"

#include <nw/snd/fnd/binary/sndfnd_PrimitiveTypes.h>
#include <mcs/handler/LoadAnimSoundHandler.h>

namespace {

// リクエストで送られるデータの構造。
struct PacketData
{
    nw::snd::internal::fnd::BinU32 type;
    unsigned char path[260];
    nw::snd::internal::fnd::BinS32 isReload;
};

}

namespace nw {
namespace snd {

//----------------------------------------------------------
void
LoadAnimSoundHandler::Initialize(AnimSoundController& animSoundController)
{
    m_AnimSoundController = &animSoundController;
}

//----------------------------------------------------------
void
LoadAnimSoundHandler::OnInvoke(
    const HioMessageHeader& header,
    const void* data,
    nw::ut::IoStream& writeStream)
{
#ifndef USE_ANIM_SOUND
    NW_LOG("[SoundPlayer] AnimSound is not available.\n");
#else
    NW_NULL_ASSERT(m_AnimSoundController);

    const PacketData* request = reinterpret_cast<const PacketData*>(data);

#if defined(NW_DEBUG)
    NW_LOG("[HIO] load animSound. : %s\n", request->path);
#endif

    const char* path = reinterpret_cast<const char*>(request->path);

    m_AnimSoundController->Load(path, request->isReload == 1);

    // TODO : ★結果コードをヘッダに含める
    HioMessageHeader replyHeader(header.message, sizeof(u32) * 4);
    //HioReplyMessageHeader replyHeader(header.message, sizeof(u32) * 4);
    //replyHeader.result = HIO_RESULT_SUCCESS;

    writeStream.Write(&replyHeader, sizeof(HioMessageHeader));

    internal::fnd::BinU32 result = HIO_RESULT_SUCCESS;
    writeStream.Write(&result, sizeof(u32));
#endif
}

} // snd
} // nw
