﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../../precompiled.h"

#ifdef NW_ENABLE_SNDCTRL
#include <nw/snd/ctrl/sndctrl_SequenceVariable.h>
using namespace nw::snd::ctrl::internal;
#else
#include <nw/snd/fnd/binary/sndfnd_PrimitiveTypes.h>
#endif
#include <mcs/ItemContainer.h>
#include <mcs/handler/GetSequenceVariablesHandler.h>

namespace nw {
namespace snd {

//----------------------------------------------------------
void
GetSequenceVariablesHandler::Initialize(
    PreviewSoundArchive& previewSoundArchive,
    HioChannel& activeChannel)
{
    m_PreviewSoundArchive = &previewSoundArchive;
    m_ActiveChannel = &activeChannel;
}

//----------------------------------------------------------
void
GetSequenceVariablesHandler::OnInvoke(
    const HioMessageHeader& header,
    const void* data,
    nw::ut::IoStream& writeStream)
{
#if defined(NW_DEBUG)
    //NW_LOG("GetSequenceVariablesHandler::OnInvoke\n");
#endif

    NW_NULL_ASSERT(m_PreviewSoundArchive);
    NW_NULL_ASSERT(m_ActiveChannel);

    std::memcpy( m_InputBuffer, data, header.size );

    u8 sOutputBuffer[ Constants::DATA_BUFFER_SIZE ];
    ItemContainerReader<ToolSoundSequenceVariableContainerHeader> inputItems( reinterpret_cast<ToolSoundItemContainer*>( m_InputBuffer ) );
    ItemContainerWriter<ToolSoundSequenceVariableContainer>       outputItems( reinterpret_cast<ToolSoundItemContainer*>( sOutputBuffer ), Constants::DATA_BUFFER_SIZE );

    outputItems.WriteBegin();

    // コンテナの内容をパラメータに展開する
    while( 1 ){

        ToolSoundSequenceVariableContainerHeader* pInputItem = inputItems.Next();
        if( NULL == pInputItem ) break;

        ToolSoundSequenceVariableContainer* pOutputItem = outputItems.Next();
        if( NULL == pOutputItem ){
            NW_ASSERT( false );
            break;
        }

        // PreviewPlayer インデックスチェック
        if( pInputItem->previewSoundIndex >= (u32)m_PreviewSoundArchive->GetPreviewSoundCount() ){
            NW_WARNING( false, "Invalid PreviewSound Index : %d\n", pInputItem->previewSoundIndex );
            continue;
        }

        PreviewSound& pPreviewSound = m_PreviewSoundArchive->GetPreviewSound( pInputItem->previewSoundIndex );

        // シーケンス変数の値を格納する
        pOutputItem->header.previewSoundIndex = pInputItem->previewSoundIndex;
        pOutputItem->header.variableType       = pInputItem->variableType;
        pOutputItem->header.trackNo            = pInputItem->trackNo;

        pPreviewSound.GetVariables( pOutputItem );
    }

    outputItems.WriteEnd();

    HioMessageHeader replyHeader(header.message, (u32)outputItems.GetSize());
    m_ActiveChannel->GetStream().Write(&replyHeader, sizeof(HioMessageHeader));
    m_ActiveChannel->GetStream().Write(outputItems.GetBuffer(), (u32)outputItems.GetSize());
}


} // snd
} // nw
