﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../../precompiled.h"

#include <nw/snd/fnd/binary/sndfnd_PrimitiveTypes.h>
#include <mcs/handler/GetAnimationFrameHandler.h>
#include <anim/GfxCoordinator.h>

namespace nw {
namespace snd {

//----------------------------------------------------------
void
GetAnimationFrameHandler::OnInvoke(
    const HioMessageHeader& header,
    const void* data,
    nw::ut::IoStream& writeStream)
{
    internal::fnd::BinF32 currentFrame = GfxCoordinator::GetInstance().GetFrame();

    // TODO : ★結果コードをヘッダに含める
    HioMessageHeader replyHeader(header.message, sizeof(f32));
    //HioReplyMessageHeader replyHeader(header.message, sizeof(f32));
    //replyHeader.result = HIO_RESULT_SUCCESS;

    writeStream.Write(&replyHeader, sizeof(HioMessageHeader));
    writeStream.Write(&currentFrame, sizeof(f32));
}

} // namespace nw::snd
} // namespace nw
