﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../../precompiled.h"

//#include "PreviewInclude.h"
#include "mcs/handler/Effect.h"
#include "../../Application.h"
#include <models/PreviewAuxBus.h>
#include <models/PreviewEffect.h>

// Preview
//#include "PreviewUtilities.h"
//#include "Module.h"

namespace nw      {
namespace snd   {


Effect::Effect(void)
{
}

Effect::~Effect(void)
{
}

//Result Effect::SetParameter(const ToolSoundEffectCommonParameter* pParam)
void Effect::SetParameter(const ToolSoundEffectCommonParameter* pParam)
{
    switch( pParam->effectType ){
    case EffectType_NoEffect:
        OnApplyNoEffect( (ToolSoundNoEffectParameter*)pParam );
        break;

    case EffectType_ReverbHi:
        OnApplyReverbHi( (ToolSoundReverbHiParameter*)pParam );
        break;

    case EffectType_ReverbStd:
        OnApplyReverbStd( (ToolSoundReverbStdParameter*)pParam );
        break;

    case EffectType_Chorus:
        OnApplyChorus( (ToolSoundChorusParameter*)pParam );
        break;

    case EffectType_Delay:
        OnApplyDelay( (ToolSoundDelayParameter*)pParam );
        break;

#if defined(NW_SND_CONFIG_ENABLE_MULTICHEFT)
    case EffectType_MultiChannelReverb:
        OnApplyMultiChannelReverb( (ToolSoundMultiChannelReverbParameter*)pParam );
        break;

    case EffectType_MultiChannelChorus:
        OnApplyMultiChannelChorus( (ToolSoundMultiChannelChorusParameter*)pParam );
        break;

    case EffectType_MultiChannelDelay:
        OnApplyMultiChannelDelay( (ToolSoundMultiChannelDelayParameter*)pParam );
        break;
#endif

    //default:
        //return SOUND_E_FAIL;
    }

    //return SOUND_S_OK;
}

void Effect::OnApplyNoEffect(ToolSoundNoEffectParameter* pParam)
{
    //EffectWindow& effectWindow = GetSoundModule()->GetEffectWindow();

//     effectWindow.SetCurrentEffectType( EffectWindow::EFFECT_TYPE_NONE,
//                                        EffectParameterConverter::AuxBusToViewer( pParam->busType ),
//                                        (int)pParam->effectIndex );

    PreviewAuxBus* previewAuxbus =
        Application::GetInstance().GetPreviewEffectManager().GetAuxBus(pParam->busType);
    PreviewEffectSet* previewEffectSet = previewAuxbus->GetEffect(pParam->effectIndex);
    previewEffectSet->SetCurrent(EFFECT_NONE);
}

void Effect::OnApplyReverbHi(ToolSoundReverbHiParameter* pParam)
{
//     EffectWindow& effectWindow = GetSoundModule()->GetEffectWindow();
//     AuxBus        targetBus    = EffectParameterConverter::AuxBusToViewer( pParam->busType );

//     // エフェクトタイプを設定する
//     effectWindow.SetCurrentEffectType( EffectWindow::EFFECT_TYPE_REVERB_HI, targetBus, (int)pParam->effectIndex );

    // ★todo DPLなしバージョンに対応しないといけない

//     FxReverbHiDpl2::ReverbHiDpl2Param newParam;

//     newParam.earlyMode       = EffectParameterConverter::ReverbEarlyModeToViewer( pParam->earlyMode );
//     newParam.preDelayTimeMax = pParam->preDelayTimeMax;
//     newParam.preDelayTime    = pParam->preDelayTime;
//     newParam.fusedMode       = EffectParameterConverter::ReverbFusedModeToViewer( pParam->fusedMode );
//     newParam.fusedTime       = pParam->fusedTime;
//     newParam.coloration      = pParam->coloration;
//     newParam.damping         = pParam->damping;
//     newParam.crosstalk       = pParam->crosstalk;
//     newParam.earlyGain       = pParam->earlyGain;
//     newParam.fusedGain       = pParam->fusedGain;
//     newParam.outGain         = pParam->outGain;

//     // エフェクトパラメータを設定する
//     effectWindow.SetReverbHiParam( newParam, targetBus, (int)pParam->effectIndex );

#if 0
    NW_LOG("busType %d\n", pParam->busType);
    NW_LOG("effectIndex %d\n", pParam->effectIndex);
    NW_LOG("earlyMode %d\n", pParam->earlyMode);
    NW_LOG("preDelayTimeMax %f\n", pParam->preDelayTimeMax);
    NW_LOG("preDelayTime %f\n", pParam->preDelayTime);
    NW_LOG("fusedMode %d\n", pParam->fusedMode);
    NW_LOG("fusedTime %f\n", pParam->fusedTime);
    NW_LOG("coloration %f\n", pParam->coloration);
    NW_LOG("damping %f\n", pParam->damping);
    NW_LOG("crosstalk %f\n", pParam->crosstalk);
    NW_LOG("earlyGain %f\n", pParam->earlyGain);
    NW_LOG("fusedGain %f\n", pParam->fusedGain);
    NW_LOG("outGain %f\n", pParam->outGain);
#endif
    PreviewAuxBus* previewAuxbus =
        Application::GetInstance().GetPreviewEffectManager().GetAuxBus(pParam->busType);
    PreviewEffectSet* previewEffectSet = previewAuxbus->GetEffect(pParam->effectIndex);
    previewEffectSet->SetCurrent(EFFECT_REVERB_HI);
    PreviewEffectReverbHi* previewEffect =
        reinterpret_cast<PreviewEffectReverbHi*>(&previewEffectSet->GetCurrent());

    previewEffect->SetEarlyReflectionMode(GetFxReverbEarlyReflectionMode(pParam->earlyMode));
    previewEffect->SetPreDelayTimeMax(pParam->preDelayTimeMax);
    previewEffect->SetPreDelayTime(pParam->preDelayTime);
    previewEffect->SetFusedMode(GetFxReverbFusedMode(
        static_cast<ToolSoundFusedMode>(u32(pParam->fusedMode))));
    previewEffect->SetFusedTime(pParam->fusedTime);
    previewEffect->SetColoration(pParam->coloration);
    previewEffect->SetDamping(pParam->damping);
    previewEffect->SetCrosstalk(pParam->crosstalk);
    previewEffect->SetEarlyGain(pParam->earlyGain);
    previewEffect->SetFusedGain(pParam->fusedGain);
    previewEffect->SetOutGain(pParam->outGain);
}

void Effect::OnApplyReverbStd(ToolSoundReverbStdParameter* pParam)
{
//     EffectWindow& effectWindow = GetSoundModule()->GetEffectWindow();
//     AuxBus        targetBus    = EffectParameterConverter::AuxBusToViewer( pParam->busType );

//     effectWindow.SetCurrentEffectType( EffectWindow::EFFECT_TYPE_REVERB_STD, targetBus, (int)pParam->effectIndex );

//     // ★todo DPLなしバージョンに対応しないといけない
//     FxReverbStdDpl2::ReverbStdDpl2Param newParam;

//     newParam.earlyMode       = EffectParameterConverter::ReverbEarlyModeToViewer( pParam->earlyMode );
//     newParam.preDelayTimeMax = pParam->preDelayTimeMax;
//     newParam.preDelayTime    = pParam->preDelayTime;
//     newParam.fusedMode       = EffectParameterConverter::ReverbFusedModeToViewer( pParam->fusedMode );
//     newParam.fusedTime       = pParam->fusedTime;
//     newParam.coloration      = pParam->coloration;
//     newParam.damping         = pParam->damping;
//     newParam.earlyGain       = pParam->earlyGain;
//     newParam.fusedGain       = pParam->fusedGain;
//     newParam.outGain         = pParam->outGain;

//     // エフェクトパラメータを設定する
//     effectWindow.SetReverbStdParam( newParam, targetBus, (int)pParam->effectIndex );

#if 0
    NW_LOG("busType %d\n", pParam->busType);
    NW_LOG("effectIndex %d\n", pParam->effectIndex);
    NW_LOG("earlyMode %d\n", pParam->earlyMode);
    NW_LOG("preDelayTimeMax %f\n", pParam->preDelayTimeMax);
    NW_LOG("preDelayTime %f\n", pParam->preDelayTime);
    NW_LOG("fusedMode %d\n", pParam->fusedMode);
    NW_LOG("fusedTime %f\n", pParam->fusedTime);
    NW_LOG("coloration %f\n", pParam->coloration);
    NW_LOG("damping %f\n", pParam->damping);
    NW_LOG("earlyGain %f\n", pParam->earlyGain);
    NW_LOG("fusedGain %f\n", pParam->fusedGain);
    NW_LOG("outGain %f\n", pParam->outGain);
#endif
   PreviewAuxBus* previewAuxbus =
        Application::GetInstance().GetPreviewEffectManager().GetAuxBus(pParam->busType);
    PreviewEffectSet* previewEffectSet = previewAuxbus->GetEffect(pParam->effectIndex);
    previewEffectSet->SetCurrent(EFFECT_REVERB_STD);
    PreviewEffectReverbStd* previewEffect =
        reinterpret_cast<PreviewEffectReverbStd*>(&previewEffectSet->GetCurrent());

    previewEffect->SetEarlyReflectionMode(GetFxReverbEarlyReflectionMode(pParam->earlyMode));
    previewEffect->SetPreDelayTimeMax(pParam->preDelayTimeMax);
    previewEffect->SetPreDelayTime(pParam->preDelayTime);
    previewEffect->SetFusedMode(GetFxReverbFusedMode(
        static_cast<ToolSoundFusedMode>(u32(pParam->fusedMode))));
    previewEffect->SetFusedTime(pParam->fusedTime);
    previewEffect->SetColoration(pParam->coloration);
    previewEffect->SetDamping(pParam->damping);
    previewEffect->SetEarlyGain(pParam->earlyGain);
    previewEffect->SetFusedGain(pParam->fusedGain);
    previewEffect->SetOutGain(pParam->outGain);
}

void Effect::OnApplyChorus(ToolSoundChorusParameter* pParam)
{
//     EffectWindow& effectWindow = GetSoundModule()->GetEffectWindow();
//     AuxBus        targetBus    = EffectParameterConverter::AuxBusToViewer( pParam->busType );

//     effectWindow.SetCurrentEffectType( EffectWindow::EFFECT_TYPE_CHORUS, targetBus, (int)pParam->effectIndex );

//     // ★todo DPLなしバージョンに対応しないといけない
//     FxChorusDpl2::ChorusDpl2Param newParam;

//     newParam.delayTime = pParam->delayTime;
//     newParam.depth     = pParam->depth;
//     newParam.rate      = pParam->rate;
//     newParam.feedback  = pParam->feedback;
//     newParam.outGain   = pParam->outGain;

//     // エフェクトパラメータを設定する
//     effectWindow.SetChorusParam( newParam, targetBus, (int)pParam->effectIndex );

#if 0
    NW_LOG("busType %d\n", pParam->busType);
    NW_LOG("effectIndex %d\n", pParam->effectIndex);
    NW_LOG("delayTime %f\n", pParam->delayTime);
    NW_LOG("depth %f\n", pParam->depth);
    NW_LOG("rate %f\n", pParam->rate);
    NW_LOG("feedback %f\n", pParam->feedback);
    NW_LOG("outGain %f\n", pParam->outGain);
#endif

   PreviewAuxBus* previewAuxbus =
        Application::GetInstance().GetPreviewEffectManager().GetAuxBus(pParam->busType);
    PreviewEffectSet* previewEffectSet = previewAuxbus->GetEffect(pParam->effectIndex);
    previewEffectSet->SetCurrent(EFFECT_CHORUS);
    PreviewEffectChorus* previewEffect =
        reinterpret_cast<PreviewEffectChorus*>(&previewEffectSet->GetCurrent());

    previewEffect->SetDelayTime(pParam->delayTime);
    previewEffect->SetDepth(pParam->depth);
    previewEffect->SetRate(pParam->rate);
    previewEffect->SetFeedback(pParam->feedback);
    previewEffect->SetOutGain(pParam->outGain);
}

void Effect::OnApplyDelay(ToolSoundDelayParameter* pParam)
{
//     EffectWindow& effectWindow = GetSoundModule()->GetEffectWindow();
//     AuxBus        targetBus    = EffectParameterConverter::AuxBusToViewer( pParam->busType );

//     effectWindow.SetCurrentEffectType( EffectWindow::EFFECT_TYPE_DELAY, targetBus, (int)pParam->effectIndex );

//     // ★todo DPLなしバージョンに対応しないといけない
//     FxDelayDpl2::DelayDpl2Param newParam;

//     newParam.maxDelay = pParam->maxDelayTime;
//     newParam.delay    = pParam->delayTime;
//     newParam.feedback = pParam->feedback;
//     newParam.outGain  = pParam->outGain;
//     newParam.lpf      = pParam->lpf;

//     // エフェクトパラメータを設定する
//     effectWindow.SetDelayParam( newParam, targetBus, (int)pParam->effectIndex );

#if 0
    NW_LOG("busType %d\n", pParam->busType);
    NW_LOG("effectIndex %d\n", pParam->effectIndex);
    NW_LOG("maxDelayTime %f\n", pParam->maxDelayTime);
    NW_LOG("delayTime %f\n", pParam->delayTime);
    NW_LOG("feedback %f\n", pParam->feedback);
    NW_LOG("outGain %f\n", pParam->outGain);
    NW_LOG("lpf %f\n", pParam->lpf);
#endif

   PreviewAuxBus* previewAuxbus =
        Application::GetInstance().GetPreviewEffectManager().GetAuxBus(pParam->busType);
    PreviewEffectSet* previewEffectSet = previewAuxbus->GetEffect(pParam->effectIndex);
    previewEffectSet->SetCurrent(EFFECT_DELAY);
    PreviewEffectDelay* previewEffect =
        reinterpret_cast<PreviewEffectDelay*>(&previewEffectSet->GetCurrent());

    previewEffect->SetMaxDelayTime(pParam->maxDelayTime);
    previewEffect->SetDelayTime(pParam->delayTime);
    previewEffect->SetFeedback(pParam->feedback);
    previewEffect->SetOutGain(pParam->outGain);
    previewEffect->SetLpf(pParam->lpf);
}

#if defined(NW_SND_CONFIG_ENABLE_MULTICHEFT)
void Effect::OnApplyMultiChannelReverb(ToolSoundMultiChannelReverbParameter* pParam)
{
    PreviewAuxBus* previewAuxbus =
        Application::GetInstance().GetPreviewEffectManager().GetAuxBus(pParam->busType);
    PreviewEffectSet* previewEffectSet = previewAuxbus->GetEffect(pParam->effectIndex);
    previewEffectSet->SetCurrent(EFFECT_MULTICH_REVERB);
    PreviewEffectMultiChReverb* previewEffect =
        reinterpret_cast<PreviewEffectMultiChReverb*>(&previewEffectSet->GetCurrent());

    previewEffect->SetEarlyMode(pParam->earlyMode);
    previewEffect->SetLateMode(pParam->lateMode);
    previewEffect->SetPreDelayTime(pParam->preDelayTime);
    previewEffect->SetDecayTime(pParam->decayTime);
    previewEffect->SetHfDecayRatio(pParam->hfDecayRatio);
    previewEffect->SetColoration(pParam->coloration);
    previewEffect->SetEarlyGain(pParam->earlyGain);
    previewEffect->SetLateGain(pParam->lateGain);
    previewEffect->SetReverbGain(pParam->reverbGain);
}

void Effect::OnApplyMultiChannelChorus(ToolSoundMultiChannelChorusParameter* pParam)
{
    PreviewAuxBus* previewAuxbus =
        Application::GetInstance().GetPreviewEffectManager().GetAuxBus(pParam->busType);
    PreviewEffectSet* previewEffectSet = previewAuxbus->GetEffect(pParam->effectIndex);
    previewEffectSet->SetCurrent(EFFECT_MULTICH_CHORUS);
    PreviewEffectMultiChChorus* previewEffect =
        reinterpret_cast<PreviewEffectMultiChChorus*>(&previewEffectSet->GetCurrent());

    previewEffect->SetDelayTime(pParam->delayTime);
    previewEffect->SetDepth(pParam->depth);
    previewEffect->SetRate(pParam->rate);
    previewEffect->SetFeedback(pParam->feedback);
    previewEffect->SetOutGain(pParam->outGain);
}

void Effect::OnApplyMultiChannelDelay(ToolSoundMultiChannelDelayParameter* pParam)
{
    PreviewAuxBus* previewAuxbus =
        Application::GetInstance().GetPreviewEffectManager().GetAuxBus(pParam->busType);
    PreviewEffectSet* previewEffectSet = previewAuxbus->GetEffect(pParam->effectIndex);
    previewEffectSet->SetCurrent(EFFECT_MULTICH_DELAY);
    PreviewEffectMultiChDelay* previewEffect =
        reinterpret_cast<PreviewEffectMultiChDelay*>(&previewEffectSet->GetCurrent());

    previewEffect->SetDelay(pParam->delay);
    previewEffect->SetFeedback(pParam->feedback);
    previewEffect->SetOutGain(pParam->outGain);
    previewEffect->SetChannelSpread(pParam->channelSpread);
    previewEffect->SetLpf(pParam->lpf);
}
#endif

nw::snd::FxReverbFusedMode Effect::GetFxReverbFusedMode(ToolSoundFusedMode mode)
{
    switch (mode)
    {
    case FusedMode_OldAxfx:
        return nw::snd::FX_REVERB_FUSED_OLD_AXFX;

    case FusedMode_MetalTank:
        return nw::snd::FX_REVERB_FUSED_METAL_TANK;

    case FusedMode_SmallRoom:
        return nw::snd::FX_REVERB_FUSED_SMALL_ROOM;

    case FusedMode_LargeRoom:
        return nw::snd::FX_REVERB_FUSED_LARGE_ROOM;

    case FusedMode_Hall:
        return nw::snd::FX_REVERB_FUSED_HALL;

    case FusedMode_Cavernous:
        return nw::snd::FX_REVERB_FUSED_CAVERNOUS;
    }

    return nw::snd::FX_REVERB_FUSED_OLD_AXFX;
}

nw::snd::FxReverbEarlyReflectionMode Effect::GetFxReverbEarlyReflectionMode(long mode)
{
    switch (mode)
    {
        case 5:
        return nw::snd::FX_REVERB_EARLY_REFLECTION_5MS;

        case 10:
        return nw::snd::FX_REVERB_EARLY_REFLECTION_10MS;

        case 15:
        return nw::snd::FX_REVERB_EARLY_REFLECTION_15MS;

        case 20:
        return nw::snd::FX_REVERB_EARLY_REFLECTION_20MS;

        case 25:
        return nw::snd::FX_REVERB_EARLY_REFLECTION_25MS;

        case 30:
        return nw::snd::FX_REVERB_EARLY_REFLECTION_30MS;

        case 35:
        return nw::snd::FX_REVERB_EARLY_REFLECTION_35MS;

        case 40:
        return nw::snd::FX_REVERB_EARLY_REFLECTION_40MS;
    }

    return nw::snd::FX_REVERB_EARLY_REFLECTION_5MS;
}

} // namespace snd
} // namespace nw
