﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../../precompiled.h"

#include <nw/snd/fnd/binary/sndfnd_PrimitiveTypes.h>
#include <mcs/handler/EditAnimSoundEventHandler.h>

namespace {

// リクエストで送られるデータの構造。
struct PacketData
{
    nw::snd::internal::fnd::BinS32 isDelete; // 更新なら0, 削除なら1
    nw::snd::internal::fnd::BinS32 index;
    nw::snd::internal::fnd::BinU32 soundID;
    unsigned char soundName[260];
    u8 volume;
    u8 padding1;
    u8 padding2;
    u8 padding3;
    nw::snd::internal::fnd::BinF32 pitch;
    nw::snd::internal::fnd::BinS32 startFrame;
    nw::snd::internal::fnd::BinS32 endFrame;
    u8 frameFlag;
    s8 loopOffset;
    u8 loopInterval;
    u8 playDirection;
    u8 sequenceVariableNo;
};

}

namespace nw {
namespace snd {

//----------------------------------------------------------
void
EditAnimSoundEventHandler::Initialize(AnimSoundController& animSoundController)
{
    m_AnimSoundController = &animSoundController;
}

//----------------------------------------------------------
void
EditAnimSoundEventHandler::OnInvoke(
    const HioMessageHeader& header,
    const void* data,
    nw::ut::IoStream& writeStream)
{
#if defined(NW_DEBUG)
    NW_LOG("EditAnimSoundEventHandler\n");
#endif
    NW_NULL_ASSERT(m_AnimSoundController);

    if(!m_AnimSoundController->IsAvailable())
    {
#if defined(NW_DEBUG)
        NW_LOG("[SoundPlayer] AnimSound is not available.\n");
#endif
        return;
    }


    const PacketData* packetData = reinterpret_cast<const PacketData*>(data);

#if defined(NW_DEBUG)
    NW_LOG("[HIO] edit animSound.\n", packetData->soundID, packetData->soundName);
    NW_LOG("[HIO]       isDelete : %d\n",     s32(packetData->isDelete));
    NW_LOG("[HIO]          index : %d\n",     s32(packetData->index));
    NW_LOG("[HIO]        soundID : 0x%08x\n", u32(packetData->soundID));
    NW_LOG("[HIO]      soundName : %s\n",     packetData->soundName);
    NW_LOG("[HIO]         volume : 0x%d\n",   packetData->volume);
    NW_LOG("[HIO]          pitch : 0x%f\n",   f32(packetData->pitch));
    NW_LOG("[HIO]     startFrame : 0x%d\n",   s32(packetData->startFrame));
    NW_LOG("[HIO]       endFrame : 0x%d\n",   s32(packetData->endFrame));
    NW_LOG("[HIO]      frameFlag : 0x%d\n",   packetData->frameFlag);
    NW_LOG("[HIO]     loopOffset : 0x%d\n",   packetData->loopOffset);
    NW_LOG("[HIO]   loopInterval : 0x%d\n",   packetData->loopInterval);
    NW_LOG("[HIO]  playDirection : 0x%d\n",   packetData->playDirection);
    NW_LOG("[HIO]    setVariable : 0x%d\n",   packetData->sequenceVariableNo);
#endif

    if (packetData->isDelete)
    {
        m_AnimSoundController->DeleteEvent(packetData->index);
    }
    else
    {
        AnimSoundModifyInfo info;
        info.soundID = packetData->soundID;
        info.soundName = (char*)packetData->soundName;
        info.volume = packetData->volume;
        info.pitch = packetData->pitch;
        info.startFrame = packetData->startFrame;
        info.endFrame = packetData->endFrame;
        info.frameFlag = packetData->frameFlag;
        info.loopOffset = packetData->loopOffset;
        info.loopInterval = packetData->loopInterval;
        info.playDirection = packetData->playDirection;
        info.sequenceVariableNo = packetData->sequenceVariableNo;

        m_AnimSoundController->ModifyEvent(packetData->index, info);
    }
}

} // snd
} // nw
