﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../precompiled.h"

#if !defined(NW_SND_EDIT_USE_MCS)
#if defined(NW_PLATFORM_CAFE)
#include <cafe/hio.h>
#elif defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK)
// TODO: NintendoSdk 対応後、このコメントを削除してください。
#include <WinSock2.h>
#endif
#endif

#include <mcs/HioManager.h>
#include <mcs/HioProtocol.h>

namespace nw {
namespace snd {

//----------------------------------------------------------
HioManager::HioManager() :
m_IsInitialized(false)
{
}

//----------------------------------------------------------
HioManager::~HioManager()
{
    Finalize();
}

//----------------------------------------------------------
bool
HioManager::Initialize()
{
    if(IsInitialized())
    {
        return true;
    }
#if defined(NW_SND_EDIT_USE_MCS)
    mcs::Mcs_Initialize();
    mcs::FileIO_Initialize();   // ★SoundPlayer に移す

    if (mcs::Mcs_Open() != mcs::MCS_ERROR_SUCCESS)
    {
        NW_WARNING(false, "failed to Mcs_Open().");
        return false;
    }
#else
#if defined(NW_PLATFORM_CAFE)
    HIOInit();
#elif defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK)
// TODO: NintendoSdk 対応後、このコメントを削除してください。
    WSADATA wsaData;
    if (WSAStartup(MAKEWORD(2, 0), &wsaData) != 0)
    {
        NW_ASSERT(false);
        return false;
    }
#endif
#endif

    m_IsInitialized = true;

    return true;
}

//----------------------------------------------------------
void
HioManager::Finalize()
{
    if(!IsInitialized())
    {
        return;
    }

#if defined(NW_SND_EDIT_USE_MCS)
    mcs::Mcs_Close();
#else
#if defined(NW_PLATFORM_CAFE)
#elif defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK)
// TODO: NintendoSdk 対応後、このコメントを削除してください。
    if (WSACleanup() != 0)
    {
        NW_ASSERT(false);
        return;
    }
#endif
#endif

    m_IsInitialized = false;
}

//----------------------------------------------------------
void
HioManager::Update()
{
    if(!IsInitialized())
    {
        return;
    }

#if defined(NW_SND_EDIT_USE_MCS)
    mcs::Mcs_Polling();

    if (!mcs::Mcs_IsServerConnect())
    {
        return;
    }
#else
    // チャンネル毎にポーリング処理を行います。
    for(HioChannelRefList::const_iterator it = HioChannelRefList::const_iterator(m_ChannelRefs.begin()); it != HioChannelRefList::const_iterator(m_ChannelRefs.end()); ++it)
    {
        it->value.Polling();
    }
#endif

    UpdateChannels();
}

//----------------------------------------------------------
void
HioManager::RegisterChannel(HioChannel& channel)
{
#if defined(NW_DEBUG)
    // 重複登録がないことをチェックします。
    for(HioChannelRefList::const_iterator it = HioChannelRefList::const_iterator(m_ChannelRefs.begin()); it != HioChannelRefList::const_iterator(m_ChannelRefs.end()); ++it)
    {
        NW_ASSERT(&it->value != &channel);
    }
#endif

    m_ChannelRefs.push_back(&channel.GetReference());
}

//----------------------------------------------------------
void
HioManager::UnregisterChannel(HioChannel& channel)
{
    // HACK: 多重 erase しないようにするための保護処理
    if(channel.GetReference().node.GetNext() == NULL &&
        channel.GetReference().node.GetPrev() == NULL)
    {
        return;
    }

    m_ChannelRefs.erase(&channel.GetReference());
}

//----------------------------------------------------------
void
HioManager::UpdateChannels()
{
    // チャンネル毎に更新します。
    for(HioChannelRefList::const_iterator it = HioChannelRefList::const_iterator(m_ChannelRefs.begin()); it != HioChannelRefList::const_iterator(m_ChannelRefs.end()); ++it)
    {
        it->value.Update();
    }
}

} // namespace nw::snd
} // namespace nw
