﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../../precompiled.h"

#include <nw/ut.h>
#include <io/cafe/WaveRendererCafe.h>

namespace nw {
namespace snd {

WaveRendererCafe::WaveRendererCafe() :
m_OutputLine(OUTPUT_MAIN)
{
}

WaveRendererCafe::~WaveRendererCafe()
{
}

WaveRendererCafe::OutputLine WaveRendererCafe::GetOutputType() const
{
    return m_OutputLine;
}

void WaveRendererCafe::SetOutputLine(OutputLine value)
{
    m_OutputLine = value;
}

void WaveRendererCafe::SetOutMix(internal::Voice& voice, const internal::fnd::WaveFormat& waveFormat, u32 channelIndex)
{
    if(m_OutputLine & OUTPUT_MAIN)
    {
        if(waveFormat.channels == 1)
        {
            OutputMix mix;
            memset(&mix, 0, sizeof(mix));

            // LR 2ch で鳴らす
            mix.mainBus[CHANNEL_INDEX_FRONT_LEFT] = 1.f;
            mix.mainBus[CHANNEL_INDEX_FRONT_RIGHT] = 1.f;

            voice.SetTvMix(mix);
        }
        else
        {
            NW_ASSERT(channelIndex < CHANNEL_INDEX_NUM);

            OutputMix mix;
            memset(&mix, 0, sizeof(mix));
            mix.mainBus[channelIndex] = 1.f;

            voice.SetTvMix(mix);
        }
    }
    else
    {
        OutputMix mix;
        memset(&mix, 0, sizeof(mix));

        voice.SetTvMix(mix);
    }

    if(m_OutputLine & OUTPUT_DRC0)
    {
        NW_ASSERT(channelIndex < DRC_OUT_CHANNEL_INDEX_NUM);

        if(waveFormat.channels == 1)
        {
            OutputMix mix;
            memset(&mix, 0, sizeof(mix));

            // LR 2ch で鳴らす
            mix.mainBus[CHANNEL_INDEX_FRONT_LEFT] = 1.f;
            mix.mainBus[CHANNEL_INDEX_FRONT_RIGHT] = 1.f;

            voice.SetDrcMix(0, mix);
        }
        else
        {
            NW_ASSERT(channelIndex < DRC_OUT_CHANNEL_INDEX_NUM);

            OutputMix mix;
            memset(&mix, 0, sizeof(mix));
            mix.mainBus[channelIndex] = 1.f;

            voice.SetDrcMix(0, mix);
        }
    }
    else
    {
        OutputMix mix;
        memset(&mix, 0, sizeof(mix));

        voice.SetDrcMix(0, mix);
    }
}

} // snd
} // nw
