﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../precompiled.h"

#include <controls/MultiChChorusParameterListView.h>

#if defined(NW_SND_CONFIG_ENABLE_MULTICHEFT)

namespace {

static f32 GetDelayTime(nw::snd::PreviewEffectMultiChChorus* pParameter)
{
    NW_ASSERT(pParameter != NULL);
    return pParameter->GetDelayTime();
}

static f32 GetDepth(nw::snd::PreviewEffectMultiChChorus* pParameter)
{
    NW_ASSERT(pParameter != NULL);
    return pParameter->GetDepth();
}

static f32 GetRate(nw::snd::PreviewEffectMultiChChorus* pParameter)
{
    NW_ASSERT(pParameter != NULL);
    return pParameter->GetRate();
}

static f32 GetFeedback(nw::snd::PreviewEffectMultiChChorus* pParameter)
{
    NW_ASSERT(pParameter != NULL);
    return pParameter->GetFeedback();
}

static f32 GetOutGain(nw::snd::PreviewEffectMultiChChorus* pParameter)
{
    NW_ASSERT(pParameter != NULL);
    return pParameter->GetOutGain();
}

static void SetDelayTime(nw::snd::PreviewEffectMultiChChorus* pParameter, f32 value)
{
    NW_ASSERT(pParameter != NULL);
    pParameter->SetDelayTime(value);
}

static void SetDepth(nw::snd::PreviewEffectMultiChChorus* pParameter, f32 value)
{
    NW_ASSERT(pParameter != NULL);
    pParameter->SetDepth(value);
}

static void SetRate(nw::snd::PreviewEffectMultiChChorus* pParameter, f32 value)
{
    NW_ASSERT(pParameter != NULL);
    pParameter->SetRate(value);
}

static void SetFeedback(nw::snd::PreviewEffectMultiChChorus* pParameter, f32 value)
{
    NW_ASSERT(pParameter != NULL);
    pParameter->SetFeedback(value);
}

static void SetOutGain(nw::snd::PreviewEffectMultiChChorus* pParameter, f32 value)
{
    NW_ASSERT(pParameter != NULL);
    pParameter->SetOutGain(value);
}

static void PrintF32Value(char* pText, u32 bufferLength, f32 value)
{
    nw::ut::snprintf(pText, bufferLength, bufferLength - 1, "%7.2f", value);
}

}

namespace nw {
namespace snd {

MultiChChorusParameterListView::MultiChChorusParameterListView()
{
    m_DelayTimeControl.Initialize(GetDelayTime, SetDelayTime, PrintF32Value);
    m_DelayTimeControl.SetLabelText("DelayTime:");
    m_DelayTimeControl.SetMinimumValue(0.1f);
    m_DelayTimeControl.SetMaximumValue(50.0f);
    m_DelayTimeControl.SetDefaultValue(10.0f);
    m_DelayTimeControl.SetValueChange(0.1f);
    m_DelayTimeControl.SetValueLargeChange(1.0f);

    m_DepthControl.Initialize(GetDepth, SetDepth, PrintF32Value);
    m_DepthControl.SetLabelText("Depth:");
    m_DepthControl.SetMinimumValue(0.0f);
    m_DepthControl.SetMaximumValue(1.0f);
    m_DepthControl.SetDefaultValue(0.5f);
    m_DepthControl.SetValueChange(0.01f);
    m_DepthControl.SetValueLargeChange(0.1f);

    m_RateControl.Initialize(GetRate, SetRate, PrintF32Value);
    m_RateControl.SetLabelText("Rate:");
    m_RateControl.SetMinimumValue(0.1f);
    m_RateControl.SetMaximumValue(2.0f);
    m_RateControl.SetDefaultValue(1.0f);
    m_RateControl.SetValueChange(0.01f);
    m_RateControl.SetValueLargeChange(0.1f);

    m_FeedbackControl.Initialize(GetFeedback, SetFeedback, PrintF32Value);
    m_FeedbackControl.SetLabelText("Feedback:");
    m_FeedbackControl.SetMinimumValue(0.0f);
    m_FeedbackControl.SetMaximumValue(1.0f);
    m_FeedbackControl.SetDefaultValue(0.0f);
    m_FeedbackControl.SetValueChange(0.01f);
    m_FeedbackControl.SetValueLargeChange(0.1f);

    m_OutGainControl.Initialize(GetOutGain, SetOutGain, PrintF32Value);
    m_OutGainControl.SetLabelText("OutGain:");
    m_OutGainControl.SetMinimumValue(0.0f);
    m_OutGainControl.SetMaximumValue(1.0f);
    m_OutGainControl.SetDefaultValue(1.0f);
    m_OutGainControl.SetValueChange(0.01f);
    m_OutGainControl.SetValueLargeChange(0.1f);

    AddItem(m_DelayTimeControl);
    AddItem(m_DepthControl);
    AddItem(m_RateControl);
    AddItem(m_FeedbackControl);
    AddItem(m_OutGainControl);
}

} // snd
} // nw

#endif
