﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../precompiled.h"

#include <controls/Lamp.h>

#include <nw/dw/system/dw_NwTypeUtility.h>

namespace nw {
namespace snd {

Lamp::Lamp()
{
    SetPadding(nw::internal::dw::Thickness(2.f, 0.f));
    SetContents(m_Contents);
    SetBackgroundColor(nw::internal::dw::NwTypeUtility::SRGBToLinear(nw::ut::Color4f(0.3f, 0.3f, 0.3f, 1.f)));
    SetBorderColor(GetBackgroundColor0());

    m_LampedBackgroundColor = nw::internal::dw::NwTypeUtility::SRGBToLinear(nw::ut::Color4f(0.5f, 0.7f, 0.3f, 1.f));
    m_LampedBorderColor = m_LampedBackgroundColor;
    m_LampedTextColor = nw::ut::Color4f::WHITE();
    m_TextColor = nw::internal::dw::NwTypeUtility::SRGBToLinear(nw::ut::Color4f::GRAY());

    m_Contents.AddItem(&m_Label);

    m_Label.SetMargin(nw::internal::dw::Thickness(0.f));
}

const char* Lamp::GetLabelText() const
{
    return m_Label.GetText();
}

void Lamp::SetLabelText(const char* pText)
{
    m_Label.SetText(pText);
}

bool Lamp::GetIsLamped() const
{
    return m_isLamped;
}

void Lamp::SetIsLamped(bool value)
{
    m_isLamped = value;
}

nw::ut::Color4f Lamp::GetLampedBackgroundColor() const
{
    return m_LampedBackgroundColor;
}

void Lamp::SetLampedBackgroundColor(nw::ut::Color4f value)
{
    m_LampedBackgroundColor = value;
}

nw::ut::Color4f Lamp::GetLampedBorderColor() const
{
    return m_LampedBorderColor;
}

void Lamp::SetLampedBorderColor(nw::ut::Color4f value)
{
    m_LampedBorderColor = value;
}

nw::ut::Color4f Lamp::GetLampedTextColor() const
{
    return m_LampedTextColor;
}

void Lamp::SetLampedTextColor(nw::ut::Color4f value)
{
    m_LampedTextColor = value;
}

nw::ut::Color4f Lamp::GetTextColor() const
{
    return m_TextColor;
}

void Lamp::SetTextColor(nw::ut::Color4f value)
{
    m_TextColor = value;
}

const nw::math::Vector2 Lamp::OnMeasure(nw::internal::dw::UIRenderer& renderer) const
{
    const char* pLabelText = GetLabelText();

    if(pLabelText == NULL || *pLabelText == '\0')
    {
        return nw::math::Vector2::Zero();
    }

    return Base::OnMeasure(renderer);
}

nw::internal::dw::UIElementRenderArgs& Lamp::OnPrepareRender(const nw::internal::dw::UIElementTreeContext& context)
{
    nw::internal::dw::UIElementRenderArgs& result = Base::OnPrepareRender(context);

    if(m_isLamped)
    {
        result.
            SetBackgroundColor(m_LampedBackgroundColor).
            SetBorderColor(m_LampedBorderColor);

        m_Label.SetTextColor(m_LampedTextColor);
    }
    else
    {
        m_Label.SetTextColor(m_TextColor);
    }

    return result;
}

} // snd
} // nw
