﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../precompiled.h"

#include <controls/FixedLabelVoiceCountPeakMeter.h>

#include <nw/dw/system/dw_NwTypeUtility.h>

namespace nw {
namespace snd {

const char* FixedLabelVoiceCountPeakMeter::VALUE_FORMAT = "%2d";

FixedLabelVoiceCountPeakMeter::FixedLabelVoiceCountPeakMeter()
{
    m_Contents.AddItem(&m_Container);
    SetContents(m_Contents);

    SetMargin(nw::internal::dw::Thickness(0.f));
    SetPadding(nw::internal::dw::Thickness(0.f));

    m_Container.SetMeasurement(nw::internal::dw::MEASUREMENT_AUTO_HEIGHT);

    m_Label.SetDock(nw::internal::dw::DOCK_LEFT);
    m_Label.SetMargin(nw::internal::dw::Thickness(2.f, 0.f, 0.f, 0.f));
    m_Label.SetVerticalAlignment(nw::internal::dw::VERTICAL_CENTER);
    m_Label.SetText("Count");

    m_Label2.SetDock(nw::internal::dw::DOCK_LEFT);
    m_Label2.SetMargin(nw::internal::dw::Thickness(0.f));
    m_Label2.SetVerticalAlignment(nw::internal::dw::VERTICAL_CENTER);
    m_Label2.SetText(":");

    m_ValueLabel.SetDock(nw::internal::dw::DOCK_LEFT);
    m_ValueLabel.SetMargin(nw::internal::dw::Thickness(0.f));
    m_ValueLabel.SetVerticalAlignment(nw::internal::dw::VERTICAL_CENTER);

    m_Label3.SetDock(nw::internal::dw::DOCK_LEFT);
    m_Label3.SetMargin(nw::internal::dw::Thickness(0.f));
    m_Label3.SetVerticalAlignment(nw::internal::dw::VERTICAL_CENTER);
    m_Label3.SetText("(");

    m_PeakValueLabel.SetDock(nw::internal::dw::DOCK_LEFT);
    m_PeakValueLabel.SetMargin(nw::internal::dw::Thickness(0.f));
    m_PeakValueLabel.SetVerticalAlignment(nw::internal::dw::VERTICAL_CENTER);

    m_Label4.SetDock(nw::internal::dw::DOCK_LEFT);
    m_Label4.SetMargin(nw::internal::dw::Thickness(0.f));
    m_Label4.SetVerticalAlignment(nw::internal::dw::VERTICAL_CENTER);
    m_Label4.SetText(") /");

    m_MaximumValueLabel.SetDock(nw::internal::dw::DOCK_LEFT);
    m_MaximumValueLabel.SetMargin(nw::internal::dw::Thickness(0.f));
    m_MaximumValueLabel.SetVerticalAlignment(nw::internal::dw::VERTICAL_CENTER);

    m_PeakMeter.SetMargin(nw::internal::dw::Thickness(2.f, 1.f));
    m_PeakMeter.SetBackgroundColor(nw::internal::dw::NwTypeUtility::SRGBToLinear(nw::ut::Color4f(0.332f, 0.360f, 0.399f, 1.f)));
    m_PeakMeter.SetMeasurement(nw::internal::dw::MEASUREMENT_MANUAL);
    m_PeakMeter.SetHeight(14.f);
    m_PeakMeter.SetVerticalAlignment(nw::internal::dw::VERTICAL_CENTER);

    m_Container.GetContents().AddItem(&m_Label);
    m_Container.GetContents().AddItem(&m_Label2);
    m_Container.GetContents().AddItem(&m_ValueLabel);
    m_Container.GetContents().AddItem(&m_Label3);
    m_Container.GetContents().AddItem(&m_PeakValueLabel);
    m_Container.GetContents().AddItem(&m_Label4);
    m_Container.GetContents().AddItem(&m_MaximumValueLabel);
    m_Container.GetContents().AddItem(&m_PeakMeter);
}

nw::internal::dw::Orientation FixedLabelVoiceCountPeakMeter::GetOrientation() const
{
    return m_PeakMeter.GetOrientation();
}

void FixedLabelVoiceCountPeakMeter::SetOrientation(nw::internal::dw::Orientation value)
{
    NW_ASSERTMSG(value == nw::internal::dw::HORIZONTAL, "Orientation 'VERTICAL' is not supported.");

    m_PeakMeter.SetOrientation(value);
}

u32 FixedLabelVoiceCountPeakMeter::GetValue() const
{
    return static_cast<u32>(m_PeakMeter.GetValue());
}

void FixedLabelVoiceCountPeakMeter::SetValue(u32 value)
{
    m_PeakMeter.SetValue(static_cast<f32>(value));
}

u32 FixedLabelVoiceCountPeakMeter::GetPeakValue() const
{
    return static_cast<u32>(m_PeakMeter.GetPeakValue());
}

u32 FixedLabelVoiceCountPeakMeter::GetMinimumValue() const
{
    return static_cast<u32>(m_PeakMeter.GetMinimumValue());
}

void FixedLabelVoiceCountPeakMeter::SetMinimumValue(u32 value)
{
    m_PeakMeter.SetMinimumValue(static_cast<f32>(value));
}

u32 FixedLabelVoiceCountPeakMeter::GetMaximumValue() const
{
    return static_cast<u32>(m_PeakMeter.GetMaximumValue());
}

void FixedLabelVoiceCountPeakMeter::SetMaximumValue(u32 value)
{
    m_PeakMeter.SetMaximumValue(static_cast<f32>(value));
}

u32 FixedLabelVoiceCountPeakMeter::GetPeakHoldChange() const
{
    return static_cast<u32>(m_PeakMeter.GetPeakHoldChange());
}

void FixedLabelVoiceCountPeakMeter::SetPeakHoldChange(u32 value)
{
    m_PeakMeter.SetPeakHoldChange(static_cast<f32>(value));
}

u32 FixedLabelVoiceCountPeakMeter::GetPeakHoldFrames() const
{
    return static_cast<u32>(m_PeakMeter.GetPeakHoldFrames());
}

void FixedLabelVoiceCountPeakMeter::SetPeakHoldFrames(u32 value)
{
    m_PeakMeter.SetPeakHoldFrames(static_cast<f32>(value));
}

const nw::ut::Color4f FixedLabelVoiceCountPeakMeter::GetBarColor() const
{
    return m_PeakMeter.GetBarColor();
}

void FixedLabelVoiceCountPeakMeter::SetBarColor(const nw::ut::Color4f& value)
{
    m_PeakMeter.SetBarColor(value);
}

void FixedLabelVoiceCountPeakMeter::OnUpdate(const nw::internal::dw::UIElementTreeContext& context)
{
    static const u32 LABEL_LENGTH = 32;
    static char labelText[LABEL_LENGTH];

    // 値のテキストを設定します。
    nw::ut::snprintf(
        labelText,
        LABEL_LENGTH,
        LABEL_LENGTH - 1,
        VALUE_FORMAT,
        static_cast<u32>(m_PeakMeter.GetValue()));

    m_ValueLabel.SetText(labelText);

    // ピーク値のテキストを設定します。
    nw::ut::snprintf(
        labelText,
        LABEL_LENGTH,
        LABEL_LENGTH - 1,
        VALUE_FORMAT,
        static_cast<u32>(m_PeakMeter.GetPeakValue()));

    m_PeakValueLabel.SetText(labelText);

    // 最大値のテキストを設定します。
    nw::ut::snprintf(
        labelText,
        LABEL_LENGTH,
        LABEL_LENGTH - 1,
        VALUE_FORMAT,
        GetMaximumValue());

    m_MaximumValueLabel.SetText(labelText);

    // オーバーフロー時はテキスト色を変更します。
    m_ValueLabel.SetTextColor(
        m_PeakMeter.IsValueInRange() ? nw::ut::Color4f::WHITE() : nw::internal::dw::NwTypeUtility::SRGBToLinear(nw::ut::Color4f(0.8f, 0.3f, 0.3f, 1.f)));

    m_PeakValueLabel.SetTextColor(
        m_PeakMeter.IsPeakValueInRange() ? nw::ut::Color4f::WHITE() : nw::internal::dw::NwTypeUtility::SRGBToLinear(nw::ut::Color4f(0.8f, 0.3f, 0.3f, 1.f)));
}

} // snd
} // nw
