﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../precompiled.h"

#include <controls/DelayParameterListView.h>

namespace {

static f32 GetMaxDelayTime(nw::snd::PreviewEffectDelay* pParameter)
{
    NW_ASSERT(pParameter != NULL);
    return pParameter->GetMaxDelayTime();
}

static f32 GetDelayTime(nw::snd::PreviewEffectDelay* pParameter)
{
    NW_ASSERT(pParameter != NULL);
    return pParameter->GetDelayTime();
}

static f32 GetFeedback(nw::snd::PreviewEffectDelay* pParameter)
{
    NW_ASSERT(pParameter != NULL);
    return pParameter->GetFeedback();
}

static f32 GetOutGain(nw::snd::PreviewEffectDelay* pParameter)
{
    NW_ASSERT(pParameter != NULL);
    return pParameter->GetOutGain();
}

static f32 GetLpf(nw::snd::PreviewEffectDelay* pParameter)
{
    NW_ASSERT(pParameter != NULL);
    return pParameter->GetLpf();
}

static void SetDelayTime(nw::snd::PreviewEffectDelay* pParameter, f32 value)
{
    NW_ASSERT(pParameter != NULL);
    pParameter->SetDelayTime(value);
}

static void SetMaxDelayTime(nw::snd::PreviewEffectDelay* pParameter, f32 value)
{
    NW_ASSERT(pParameter != NULL);

    if(value < GetDelayTime(pParameter))
    {
        SetDelayTime(pParameter, value);
    }

    pParameter->SetMaxDelayTime(value);
}

static void SetFeedback(nw::snd::PreviewEffectDelay* pParameter, f32 value)
{
    NW_ASSERT(pParameter != NULL);
    pParameter->SetFeedback(value);
}

static void SetOutGain(nw::snd::PreviewEffectDelay* pParameter, f32 value)
{
    NW_ASSERT(pParameter != NULL);
    pParameter->SetOutGain(value);
}

static void SetLpf(nw::snd::PreviewEffectDelay* pParameter, f32 value)
{
    NW_ASSERT(pParameter != NULL);
    pParameter->SetLpf(value);
}

static void PrintF32Value(char* pText, u32 bufferLength, f32 value)
{
    nw::ut::snprintf(pText, bufferLength, bufferLength - 1, "%7.2f", value);
}

}

namespace nw {
namespace snd {

DelayParameterListView::DelayParameterListView()
{
    m_MaxDelayTimeControl.Initialize(GetMaxDelayTime, SetMaxDelayTime, PrintF32Value);
    m_MaxDelayTimeControl.SetLabelText("MaxDelayTime:");
    m_MaxDelayTimeControl.SetMinimumValue(1.f);
    m_MaxDelayTimeControl.SetMaximumValue(5000.f);
    m_MaxDelayTimeControl.SetDefaultValue(500.f);
    m_MaxDelayTimeControl.SetValueChange(1.f);
    m_MaxDelayTimeControl.SetValueLargeChange(10.f);

    m_DelayTimeControl.Initialize(GetDelayTime, SetDelayTime, PrintF32Value);
    m_DelayTimeControl.SetLabelText("DelayTime:");
    m_DelayTimeControl.SetMinimumValue(1.f);
    m_DelayTimeControl.SetMaximumValue(1.f);
    m_DelayTimeControl.SetDefaultValue(160.f);
    m_DelayTimeControl.SetValueChange(1.f);
    m_DelayTimeControl.SetValueLargeChange(10.f);

    m_FeedbackControl.Initialize(GetFeedback, SetFeedback, PrintF32Value);
    m_FeedbackControl.SetLabelText("Feedback:");
    m_FeedbackControl.SetMinimumValue(0.f);
    m_FeedbackControl.SetMaximumValue(0.99f);
    m_FeedbackControl.SetDefaultValue(0.4f);
    m_FeedbackControl.SetValueChange(0.01f);
    m_FeedbackControl.SetValueLargeChange(0.1f);

    m_OutGainControl.Initialize(GetOutGain, SetOutGain, PrintF32Value);
    m_OutGainControl.SetLabelText("OutGain:");
    m_OutGainControl.SetMinimumValue(0.f);
    m_OutGainControl.SetMaximumValue(1.f);
    m_OutGainControl.SetDefaultValue(1.f);
    m_OutGainControl.SetValueChange(0.01f);
    m_OutGainControl.SetValueLargeChange(0.1f);

    m_LpfControl.Initialize(GetLpf, SetLpf, PrintF32Value);
    m_LpfControl.SetLabelText("Lpf:");
    m_LpfControl.SetMinimumValue(0.f);
    m_LpfControl.SetMaximumValue(1.f);
    m_LpfControl.SetDefaultValue(1.f);
    m_LpfControl.SetValueChange(0.01f);
    m_LpfControl.SetValueLargeChange(0.1f);

    AddItem(m_MaxDelayTimeControl);
    AddItem(m_DelayTimeControl);
    AddItem(m_FeedbackControl);
    AddItem(m_OutGainControl);
    AddItem(m_LpfControl);
}

void DelayParameterListView::OnPrepareMeasure()
{
    if(m_MaxDelayTimeControl.GetModel() != NULL)
    {
        m_DelayTimeControl.SetMaximumValue(m_MaxDelayTimeControl.GetValue());
    }
}

} // snd
} // nw
