﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <panels/WavePreviewPanel.h>

#if defined(NW_PLATFORM_CAFE)
#include <cafe/fs.h>
#endif

#include <nw/snd/fnd/io/sndfnd_FileStreamImpl.h>
#include <nw/dw/control/dw_FixedUIElementList.h>
#include <nw/dw/control/cafe/dw_FileBrowserCafe.h>
#include <io/cafe/WaveRendererCafe.h>

namespace nw {
namespace snd {

class IResourceProvider;

class WavePreviewCafePanel : public WavePreviewPanel
{
private:
    typedef WavePreviewPanel Base;

public:
    WavePreviewCafePanel();
    virtual ~WavePreviewCafePanel();

public:
    bool Initialize(IResourceProvider& resourceProvider);
    void Finalize();

protected:
    virtual internal::fnd::FileStream* OpenFileImpl(const char* filePath);
    virtual internal::fnd::FileStream* GetOpenedFileStream()
    {
        return m_FileStream.IsOpened() ? &m_FileStream : NULL;
    }

    virtual WaveRenderer& GetWaveRenderer();

    virtual void InitializeLampBar(nw::internal::dw::StackPanel& lampBar);
    virtual void SetOutputLine(WaveRenderer& renderer);

    virtual bool OnUpdateFocusedInput(const nw::internal::dw::Inputs& inputs);

private:
    bool IsMainOutput();

private:
#if defined(NW_PLATFORM_CAFE)
    FSClient* m_FsClient;
    FSCmdBlock* m_FsCmdBlock;
    FSCmdBlock* m_FsCmdBlockForPreview;
#endif

    internal::fnd::FileStreamImpl m_FileStream;
    WaveRendererCafe m_WaveRenderer;

    nw::internal::dw::FileBrowserCafe m_FileBrowser;

    nw::internal::dw::FixedUIElementList<2> m_LampBarContents;
    Lamp m_MainLamp;
    Lamp m_DrcLamp;

#if defined(NW_DEBUG)
public:
    /*override*/ const char* ToString() const
    {
        return "FileBrowserCafe";
    }
#endif
};

} // snd
} // nw
