﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <panels/SoundSystemPanel.h>
#include <controls/F32ParameterListItem.h>

namespace nw {
namespace snd {

#if defined(NW_PLATFORM_WIN32) || defined(NW_USE_NINTENDO_SDK)
// TODO: NintendoSdk 対応後、このコメントを削除してください。

    enum AXDRCVSOutputMode
    {
        AX_DRC_VS_OUTPUT_SPEAKER,
        AX_DRC_VS_OUTPUT_HEADPHONE
    };

    enum AXDRCVSSpeakerPosition
    {
        AX_DRC_VS_SPEAKER_POS_WIDE,
        AX_DRC_VS_SPEAKER_POS_SQUARE
    };

    enum AXDRCVSSurroundLevelGain
    {
        AX_DRC_VS_SLEV_1_0,
        AX_DRC_VS_SLEV_0_707,
        AX_DRC_VS_SLEV_0_5,
    };

#endif

class SoundSystemCafePanel : public SoundSystemPanel
{
public:
    struct DRCVSParams
    {
        AXDRCVSOutputMode outputMode;
        AXDRCVSSpeakerPosition speakerPosition;
        f32 surroundDepth;
        f32 downmixBalance;
        AXDRCVSSurroundLevelGain surroundLevelGain;
        f32 outputGain;

        DRCVSParams()
        : outputMode(AX_DRC_VS_OUTPUT_SPEAKER)
        , speakerPosition(AX_DRC_VS_SPEAKER_POS_WIDE)
        , surroundDepth(1.0f)
        , downmixBalance(1.0f)
        , surroundLevelGain(AX_DRC_VS_SLEV_1_0)
        , outputGain(1.0f)
        {
        }
    };

public:
    SoundSystemCafePanel();
    virtual ~SoundSystemCafePanel();

private:
    DRCVSParams m_DRCVSParams;

private:
    SelectableParameterListItem<DRCVSParams, AXDRCVSOutputMode> m_DRCVSOutputModeControl;
    SelectableParameterListItem<DRCVSParams, AXDRCVSSpeakerPosition> m_DRCVSSpeakerPositionControl;
    F32ParameterListItem<DRCVSParams> m_DRCVSSurroundDepthControl;
    F32ParameterListItem<DRCVSParams> m_DRCVSDownmixBalanceControl;
    SelectableParameterListItem<DRCVSParams, AXDRCVSSurroundLevelGain> m_DRCVSSurroundLevelGainControl;
    F32ParameterListItem<DRCVSParams> m_DRCVSOutputGainControl;

#if defined(NW_DEBUG)
public:
    /*override*/ const char* ToString() const
    {
        return "SoundSystemCafePanel";
    }
#endif
};

} // snd
} // nw
