﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <panels/SoundParameterPanel.h>
#include <controls/F32ParameterListItem.h>

namespace nw {
namespace snd {

class SoundParameterCafePanel : public SoundParameterPanel
{
public:
    SoundParameterCafePanel();

private:
    F32ParameterListItem<PreviewSound> m_MainSendControl;
    F32ParameterListItem<PreviewSound> m_FxSendAControl;
    F32ParameterListItem<PreviewSound> m_FxSendBControl;
    F32ParameterListItem<PreviewSound> m_FxSendCControl;

    F32ParameterListItem<PreviewSound> m_LpfFrequencyControl;
    SelectableParameterListItem<PreviewSound, BiquadFilterType> m_BiquadFilterTypeControl;
    F32ParameterListItem<PreviewSound> m_BiquadFilterValueControl;

    F32ParameterListItem<PreviewSound> m_MainOutVolumeControl;
    F32ParameterListItem<PreviewSound> m_DrcOutVolumeControl;
    F32ParameterListItem<PreviewSound> m_Remote0OutVolumeControl;
    F32ParameterListItem<PreviewSound> m_Remote1OutVolumeControl;
    F32ParameterListItem<PreviewSound> m_Remote2OutVolumeControl;
    F32ParameterListItem<PreviewSound> m_Remote3OutVolumeControl;

    F32ParameterListItem<PreviewSound> m_MainPanControl;
    F32ParameterListItem<PreviewSound> m_MainSurroundPanControl;
    F32ParameterListItem<PreviewSound> m_MainMainSendControl;
    F32ParameterListItem<PreviewSound> m_MainFxSendAControl;
    F32ParameterListItem<PreviewSound> m_MainFxSendBControl;
    F32ParameterListItem<PreviewSound> m_MainFxSendCControl;

    F32ParameterListItem<PreviewSound> m_DrcPanControl;
    F32ParameterListItem<PreviewSound> m_DrcSurroundPanControl;
    F32ParameterListItem<PreviewSound> m_DrcMainSendControl;
    F32ParameterListItem<PreviewSound> m_DrcFxSendAControl;
    F32ParameterListItem<PreviewSound> m_DrcFxSendBControl;
    F32ParameterListItem<PreviewSound> m_DrcFxSendCControl;

#if defined(NW_DEBUG)
public:
    /*override*/ const char* ToString() const
    {
        return "SoundParameterCafePanel";
    }
#endif
};

} // snd
} // nw
