﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/dw/control/dw_UIElement.h>
#include <nw/dw/control/dw_FixedUIElementList.h>
#include <nw/dw/control/dw_FixedListBox.h>
#include <models/IPreviewSoundSelector.h>
#include <models/PreviewSoundArchive.h>
#include <controls/PreviewSoundListItem.h>

namespace nw {
namespace snd {

//---------------------------------------------------------------------------
//! @brief  SoundArchivePlayerPanel クラスです。
//---------------------------------------------------------------------------
class SoundArchivePlayerPanel :
    public nw::internal::dw::UIElement,
    public IPreviewSoundSelector
{
public:
    SoundArchivePlayerPanel();

public:
    void Initialize(nw::snd::PreviewSoundArchive& previewSoundArchive);

    PreviewSoundListItem* GetPreviewSoundListItem(s32 index);

    /*override*/ PreviewSound* GetSelectedPreviewSoundFirst() const;

    /*override*/ SelectionChangedEvent& GetSelectionChangedEvent();

private:
    void OnSoundHandleListSelectionChanged();

private:
    nw::internal::dw::FixedUIElementList<1> m_Contents;
    nw::internal::dw::FixedListBox<PreviewSoundArchive::PREVIEW_SOUND_COUNT> m_Container;

    PreviewSoundListItem m_SoundHandle[PreviewSoundArchive::PREVIEW_SOUND_COUNT];

    nw::snd::PreviewSoundArchive* m_pPreviewSoundArchive;
    nw::internal::dw::ListBox::SelectionChangedEventHandler m_SoundHandleListSelectionChangedObserver;
    SelectionChangedEvent m_SelectionChangedEvent;

#if defined(NW_DEBUG)
public:
    /*override*/ const char* ToString() const
    {
        return "SoundArchivePlayerPanel";
    }
#endif
};

} // snd
} // nw
