﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/snd/util/sndutil_MidiManager.h>
#include <nw/dw/control/dw_UIElement.h>
#include <nw/dw/control/dw_FixedUIElementList.h>
#include <nw/dw/control/dw_FixedListBox.h>
#include <models/PreviewSoundArchive.h>
#include <controls/PreviewBankListItem.h>
#include <controls/PreviewSequenceListItem.h>
#include <controls/F32ParameterListItem.h>
#include <controls/Lamp.h>

namespace nw {
namespace snd {

//---------------------------------------------------------------------------
//! @brief  PreviewBankPanel クラスです。
//---------------------------------------------------------------------------
class PreviewBankPanel :
    public nw::internal::dw::UIElement
{
public:
    PreviewBankPanel();

public:
    void Initialize(nw::snd::PreviewSoundArchive& previewSoundArchive);
    void Finalize();

protected:
    /*override*/ bool OnPreviewUpdateFocusedInput(const nw::internal::dw::Inputs& inputs);
    /*override*/ bool OnUpdateFocusedInput(const nw::internal::dw::Inputs& inputs);
    /*override*/ void OnUpdate(const nw::internal::dw::UIElementTreeContext& context);

private:
    void CheckSoundArchive();

    void UpdateBankState();
    void UpdateDataVolume();

    bool IsLoaded(const PreviewBank& previewBank) const;

    void LoadBanks();
    void UnloadBanks();

private:
    nw::internal::dw::FixedUIElementList<1> m_Contents;
    nw::internal::dw::FixedDockPanel<2> m_Container;
    nw::internal::dw::FixedListBox<10> m_List;

    nw::internal::dw::FixedLabel<32> m_SeqLabel;
    PreviewSequenceListItem m_PreviewSequence;
    nw::internal::dw::FixedLabel<32> m_DataVolumeLabel;
    nw::internal::dw::FixedLabel<32> m_BankLabel;
    PreviewBankListItem m_PreviewBank[PreviewSoundArchive::PREVIEW_BANK_COUNT];
    nw::internal::dw::FixedLabel<32> m_EmptyLabel;
    F32ParameterListItem<util::MidiManager> m_Volume;
    nw::internal::dw::FixedStackPanel<3> m_LampBar;
    Lamp m_MainLamp;
    Lamp m_DrcLamp;
    Lamp m_MainAndDrcLamp;

    nw::snd::PreviewSoundArchive* m_pPreviewSoundArchive;
    SoundArchive* m_pLastSoundArchive;

    nw::snd::util::MidiManager m_MidiManager;
    s32 m_MidiThreadPriority;

    void* m_pMemoryForMidiManager;

    u32 m_LoadedBankIds[PreviewSoundArchive::PREVIEW_BANK_COUNT];

    u32 m_OutputLines;

#if defined(NW_DEBUG)
public:
    /*override*/ const char* ToString() const
    {
        return "PreviewBankPanel";
    }
#endif
};

} // snd
} // nw
