﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/ut/ut_Memory.h>
#include <nw/snd/snd_WavOutRecorder.h>
#include <nw/snd/snd_DrcWavOutRecorder.h>
#include <nw/snd/fnd/io/sndfnd_FileStreamImpl.h>
#include <nw/snd/fnd/io/sndfnd_LegacyStreamAdaptor.h>
#include <nw/dw/control/dw_UIElement.h>
#include <nw/dw/control/dw_FixedUIElementList.h>
#include <nw/dw/control/dw_FixedLabel.h>
#include <nw/dw/control/dw_FixedStackPanel.h>
#include <nw/dw/control/dw_Canvas.h>
#include <nw/dw/control/dw_Separator.h>
#include <controls/WaveGraph.h>
#include <controls/Lamp.h>

namespace nw {
namespace snd {

class IResourceProvider;

class MasterOutputPanel : public nw::internal::dw::UIElement, internal::ReadOnlyFinalMixCallback
{
private:
    static const u32 MAIN_CHANNEL_START     = 0;
    static const u32 DRC_CHANNEL_START      = 6;

    static const u32 MAIN_FL_INDEX          = 0;
    static const u32 MAIN_FR_INDEX          = 1;
    static const u32 MAIN_FC_INDEX          = 2;
    static const u32 MAIN_LFE_INDEX         = 3;
    static const u32 MAIN_RL_INDEX          = 4;
    static const u32 MAIN_RR_INDEX          = 5;
    static const u32 DRC_FL_INDEX           = 6;
    static const u32 DRC_FR_INDEX           = 7;
    static const u32 DRC_RL_INDEX           = 8;
    static const u32 DRC_RR_INDEX           = 9;

    static const u32 MAX_MAIN_CHANNEL_COUNT = 6;
    static const u32 MAX_DRC_CHANNEL_COUNT  = 4;
    static const u32 MAX_CHANNEL_COUNT      = MAX_MAIN_CHANNEL_COUNT + MAX_DRC_CHANNEL_COUNT;
    static const f32 MAX_SCALE_X;
    static const f32 MIN_SCALE_X;

    static const u32 SAMPLE_BUFFER_SIZE        = 192 * 1024;
    static const u32 GRAPH_CACHE_BUFFER_SIZE   = 16 * 1024;

    static const u32 FILE_IO_BUFFER_ALIGNMENT  = 64;
    static const u32 RECORDING_BUFFER_SIZE     = 512 * 1024 + FILE_IO_BUFFER_ALIGNMENT;
    static const u32 DRC_RECORDING_BUFFER_SIZE = 256 * 1024 + FILE_IO_BUFFER_ALIGNMENT;

    static const u32 SAMPLES_PER_SEC = 48000;

public:
    MasterOutputPanel();
    virtual ~MasterOutputPanel();

public:
    void Initialize(IResourceProvider& resourceProvider);
    void Finalize();

    f32 GetScaleX() const;
    void SetScaleX(f32 value);

    void Pause();
    void Resume();
    bool IsPaused() const;

    void StartRecording();
    void StopRecording();
    bool IsRecording();

    Lamp* GetRecordingLamp() { return m_pRecordingLamp; }
    void  SetRecordingLamp(Lamp* pLamp);

protected:
    /*override*/ bool OnUpdateFocusedInput(const nw::internal::dw::Inputs& inputs);
    /*override*/ void OnUpdate(const nw::internal::dw::UIElementTreeContext& context);

private:
    /*override*/ void OnFinalMix(OutputDevice device, const FinalMixData* data);

    inline s16* GetSamples(u32 channel);
    inline s16* GetDrcSamples(u32 channel);

    void UpdateWaveGraph(const FinalMixData* data);
    void UpdateDrcWaveGraph(const FinalMixData* data);

    void ClearSamples();

    char *GetSaveDir(char* outBuf, size_t outBufSize) const;

private:
    nw::internal::dw::FixedUIElementList<1> m_Contents;
    nw::internal::dw::FixedStackPanel<MAX_CHANNEL_COUNT + MAX_CHANNEL_COUNT - 1> m_Container;

    WaveGraph m_WaveGraphs[MAX_CHANNEL_COUNT];
    nw::internal::dw::Separator m_Separators[MAX_CHANNEL_COUNT-1];

    nw::internal::dw::UIElement m_Channels[MAX_CHANNEL_COUNT];
    nw::internal::dw::FixedUIElementList<2> m_ChannelContentsArray[MAX_CHANNEL_COUNT];
    nw::internal::dw::FixedLabel<12> m_ChannelLabels[MAX_CHANNEL_COUNT];

    Lamp* m_pRecordingLamp;

    s16 m_Samples[MAX_CHANNEL_COUNT][SAMPLE_BUFFER_SIZE];
    u32 m_SampleCount;
    u32 m_CurrentSampleIndex;
    u32 m_DrcCurrentSampleIndex;

    u8 m_RecordingSamples[RECORDING_BUFFER_SIZE];
    u8 m_DrcRecordingSamples[DRC_RECORDING_BUFFER_SIZE];
    s16 m_GraphCacheBuffers[MAX_CHANNEL_COUNT][GRAPH_CACHE_BUFFER_SIZE];

    nw::snd::OutputMode m_CurrentOutputMode;
    bool m_IsWaveGraphPaused;

#if defined(NW_PLATFORM_CAFE)
    ut::IAllocator* m_Allocator;
    FSClient* m_FsClient;
    FSCmdBlock* m_FsCmdBlock;
    FSCmdBlock* m_FsCmdBlockForDrc;
    const char* m_HfioVolume;
#endif

    internal::fnd::FileStreamImpl m_RecordingWavFile;
    internal::fnd::FileStreamImpl m_DrcRecordingWavFile;
    internal::fnd::LegacyFileStreamAdaptor m_RecordingWavFileAdaptor;
    internal::fnd::LegacyFileStreamAdaptor m_DrcRecordingWavFileAdaptor;
    nw::snd::WavOutRecorder m_WavOutRecorder;
    nw::snd::DrcWavOutRecorder m_DrcWavOutRecorder;

    static MasterOutputPanel* s_pThis;

#if defined(NW_DEBUG)
public:
    /*override*/ const char* ToString() const
    {
        return "MasterOutputPanel";
    }
#endif
};

} // snd
} // nw
