﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <models/PreviewEffect.h>

namespace nw {
namespace snd {

//---------------------------------------------------------------------------
//! @brief PreviewEffectSet
//---------------------------------------------------------------------------
class PreviewEffectSet
{
public:
    PreviewEffectSet();

    bool GetIsDirty() const;
    void ResetIsDirty();

    IPreviewEffect& GetCurrent() const;
    void SetCurrent(PreviewEffectType previewEffectType);
    u32 GetCurrentRequiredMemorySize() const;

    IPreviewEffect* GetAssignedEffect() const;
    bool AssignBuffer(void* pBuffer, u32 bufferSize);
    void ReleaseBuffer();

    void SetChannelMode(FxBase::ChannelMode mode);

private:
    bool m_IsDirty;
    IPreviewEffect* m_pCurrent;
    IPreviewEffect* m_pAssignedEffect;

    PreviewEffectNone      m_None;
    PreviewEffectReverbHi  m_ReverbHi;
    PreviewEffectReverbStd m_ReverbStd;
    PreviewEffectChorus    m_Chorus;
    PreviewEffectDelay     m_Delay;
#if defined(NW_SND_CONFIG_ENABLE_MULTICHEFT)
    PreviewEffectMultiChReverb m_MultiChReverb;
    PreviewEffectMultiChChorus m_MultiChChorus;
    PreviewEffectMultiChDelay  m_MultiChDelay;
#endif
};

} // nw::snd
} // nw
