﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <models/PreviewEffectSet.h>

namespace nw {
namespace snd {

//---------------------------------------------------------------------------
//! @brief PreviewAuxBus
//---------------------------------------------------------------------------
class PreviewAuxBus
{
public:
    struct InitializeArgs
    {
        InitializeArgs() :
            auxBus(AUX_BUS_A),
            pEffects(NULL),
            effectCount(0),
            pBuffer(NULL),
            bufferSize(0),
            device(OUTPUT_DEVICE_MAIN)
        {}

        AuxBus auxBus;
        PreviewEffectSet* pEffects;
        s32 effectCount;
        void* pBuffer;
        u32 bufferSize;
        OutputDevice device;
    };

public:
    PreviewAuxBus();

public:
    void Initialize(const InitializeArgs args);
    void Finalize();

    PreviewEffectSet* GetEffect(s32 effectIndex);

    u32 GetAssinedSize() { return m_AssinedSize; }

    void Apply();
    void Clear();

private:
    AuxBus m_AuxBus;
    OutputDevice m_Device;

    PreviewEffectSet* m_pEffects;
    s32 m_EffectCount;

    void* m_pBuffer;
    u32 m_BufferSize;
    u32 m_AssinedSize;
};

} // nw::snd
} // nw
