﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <core/TaskThread.h>
#include <core/AlignedArray.h>
#include <io/WaveformStreamReadTask.h>

namespace nw {
namespace snd {

namespace internal {
namespace fnd {
class WaveformStreamReader;
}
}

class ASyncWaveReader
{
private:
    static const u32 BUFFER_SIZE = 512 * 4;

public:
    ASyncWaveReader();
    ~ASyncWaveReader();

public:
    bool Open(internal::fnd::WaveformStreamReader* reader, IStreamWriter* writer);
    void Close();

    bool IsOpened();
    bool IsFinished();

private:
    WaveformStreamReadTask* GetIdleTask();

private:
    TaskThread m_TaskThread;
    WaveformStreamReadTask m_Task;

    AlignedArray<u8, BUFFER_SIZE, 64> m_Buffer;
};

} // snd
} // nw
