﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <controls/ParameterListItem.h>

namespace nw {
namespace snd {

template<class TModel>
class U32ParameterListItem : public ModelParameterListItem<TModel>
{
private:
    typedef ModelParameterListItem<TModel> Base;

public:
    typedef u32  (*GetValueHandler)(TModel* pPreviewSound);
    typedef void (*SetValueHandler)(TModel* pPreviewSound, u32 value);
    typedef void (*PrintValueHandler)(char* pText, u32 bufferLength, u32 value);

public:
    U32ParameterListItem();
    virtual ~U32ParameterListItem() { }

public:
    void Initialize(
        GetValueHandler pGetValueHandler,
        SetValueHandler pSetValueHandler,
        PrintValueHandler pPrintValueHandler);

    void Initialize(
        GetIsCheckedHandler pGetIsCheckedHandler,
        SetIsCheckedHandler pSetIsCheckedHandler,
        GetValueHandler pGetValueHandler,
        SetValueHandler pSetValueHandler,
        PrintValueHandler pPrintValueHandler);

    u32 GetValue() const;
    void SetValue(u32 value);

    u32 GetDefaultValue() const;
    void SetDefaultValue(u32 value);

    u32 GetValueChange() const;
    void SetValueChange(u32 value);

    u32 GetValueLargeChange() const;
    void SetValueLargeChange(u32 value);

    u32 GetMinimumValue() const;
    void SetMinimumValue(u32 value);

    u32 GetMaximumValue() const;
    void SetMaximumValue(u32 value);

    /*override*/ void ResetValue();

protected:
    /*override*/ void NextValue(bool isLargeChange);
    /*override*/ void PreviousValue(bool isLargeChange);
    /*override*/ void PrintValue(char* pText, u32 bufferLength);

private:
    u32 m_DefaultValue;
    u32 m_ValueChange;
    u32 m_ValueLargeChange;
    u32 m_MinimumValue;
    u32 m_MaximumValue;

    GetValueHandler m_pGetValueHandler;
    SetValueHandler m_pSetValueHandler;
    PrintValueHandler m_pPrintValueHandler;

#if defined(NW_DEBUG)

public:
    virtual const char* ToString() const
    {
        return "U32ParameterListItem";
    }

#endif
};

} // snd
} // nw

#include "U32ParameterListItem.hpp"
