﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/snd.h>
#include <nw/dw/control/dw_UIElement.h>
#include <nw/dw/control/dw_FixedStackPanel.h>
#include <nw/dw/control/dw_FixedLabel.h>

namespace nw {
namespace snd {

class PreviewSound;

class PreviewSoundListItem : public nw::internal::dw::UIElement
{
private:
    static const char StoppedStateLabel[];
    static const char PlayingStateLabel[];
    static const char PausedStateLabel[];
    static const nw::ut::Color4f& StoppedColor;
    static const nw::ut::Color4f& PlayingColor;
    static const nw::ut::Color4f& PausedColor;

public:
    PreviewSoundListItem();

public:
    void Initialize(PreviewSound& previewSound);

    PreviewSound& GetPreviewSound();

protected:
    /* override */ bool OnUpdateMouse(const nw::math::Vector2& position, const dev::Mouse& mouse);

    /*override*/ bool OnUpdateFocusedInput(const nw::internal::dw::Inputs& inputs);

    /*override*/ void OnUpdate(const nw::internal::dw::UIElementTreeContext& context);

private:
    void UpdateState();
    void UpdateIDLabel();
    void UpdateLabel();

private:
    nw::internal::dw::FixedUIElementList<1> m_Contents;
    nw::internal::dw::FixedStackPanel<3> m_Container;

    nw::internal::dw::FixedLabel<8> m_StateLabel;
    nw::internal::dw::FixedLabel<8> m_IDLabel;
    nw::internal::dw::FixedLabel<25> m_Label;

    PreviewSound* m_pPreviewSound;
    u32 m_SoundIndex;

#if defined(NW_DEBUG)

private:
    static const u32 DEBUG_TEXT_LENGTH = 64;

public:
    /*override*/ const char* ToString() const;

private:
    char m_DebugText[DEBUG_TEXT_LENGTH];

#endif
};

} // snd
} // nw
