﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/snd.h>
#include <nw/dw/control/dw_UIElement.h>
#include <nw/dw/control/dw_FixedStackPanel.h>
#include <nw/dw/control/dw_FixedLabel.h>

namespace nw {
namespace snd {

class PreviewBank;

class PreviewBankListItem : public nw::internal::dw::UIElement
{
public:
    PreviewBankListItem();

public:
    void Initialize(PreviewBank& previewBank);

    PreviewBank& GetPreviewBank();

protected:
    /*override*/ bool OnUpdateMouse(const nw::math::Vector2& position, const dev::Mouse& mouse);
    /*override*/ bool OnUpdateFocusedInput(const nw::internal::dw::Inputs& inputs);
    /*override*/ void OnUpdate(const nw::internal::dw::UIElementTreeContext& context);

private:
    void UpdateState();
    void UpdateIDLabel();
    void UpdateLabel();

private:
    nw::internal::dw::FixedUIElementList<1> m_Contents;
    nw::internal::dw::FixedStackPanel<3> m_Container;

    nw::internal::dw::FixedLabel<2> m_StateLabel;
    nw::internal::dw::FixedLabel<32> m_IDLabel;
    nw::internal::dw::FixedLabel<32> m_Label;

    PreviewBank* m_pPreviewBank;

#if defined(NW_DEBUG)

private:
    static const u32 DEBUG_TEXT_LENGTH = 64;

public:
    /*override*/ const char* ToString() const;

private:
    char m_DebugText[DEBUG_TEXT_LENGTH];

#endif
};

} // snd
} // nw
