﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/dw/system/dw_Types.h>
#include <nw/dw/control/dw_UIElement.h>

namespace nw {
namespace snd {

class PeakMeter : public nw::internal::dw::UIElement
{
private:
    typedef nw::internal::dw::UIElement Base;

    static const f32 PEAKHOLD_SIZE;

public:
    PeakMeter();

public:
    nw::internal::dw::Orientation GetOrientation() const;
    void SetOrientation(nw::internal::dw::Orientation value);

    float GetValue() const;
    void SetValue(float value);

    float GetPeakValue() const;
    bool IsPeakHoldEnabled() const;

    bool IsValueInRange() const;
    bool IsPeakValueInRange() const;

    float GetMinimumValue() const;
    void SetMinimumValue(float value);

    float GetMaximumValue() const;
    void SetMaximumValue(float value);

    float GetPeakHoldChange() const;
    void SetPeakHoldChange(float value);

    float GetPeakHoldFrames() const;
    void SetPeakHoldFrames(float value);

    const nw::ut::Color4f GetBarColor() const;
    void SetBarColor(const nw::ut::Color4f& value);

    const nw::ut::Color4f GetOverflowBarColor() const;
    void SetOverflowBarColor(const nw::ut::Color4f& value);

    const nw::ut::Color4f GetOverflowBackgroundColor() const;
    void SetOverflowBackgroundColor(const nw::ut::Color4f& value);

protected:
    /*override*/ const nw::math::Vector2 OnMeasure(nw::internal::dw::UIRenderer& renderer) const;
    /*override*/ void OnUpdate(const nw::internal::dw::UIElementTreeContext& context);
    /*override*/ void OnRender(const nw::internal::dw::UIElementTreeContext& context, nw::internal::dw::UIRenderer& renderer, nw::internal::dw::UIElementRenderArgs& args) const;

private:
    float GetValueInRange() const;
    float GetPeakValueInRange() const;

    void RenderByHorizontal(const nw::internal::dw::UIElementTreeContext& context, nw::internal::dw::UIRenderer& renderer, nw::internal::dw::UIElementRenderArgs& args) const;
    void RenderByVertical(const nw::internal::dw::UIElementTreeContext& context, nw::internal::dw::UIRenderer& renderer, nw::internal::dw::UIElementRenderArgs& args) const;

private:
    nw::internal::dw::Orientation m_Orientation;

    float m_Value;
    float m_PeakValue;
    float m_MinimumValue;
    float m_MaximumValue;
    float m_PeakHoldChange;
    float m_PeakHoldFrames;
    float m_RemainPeakHoldFrames;
    nw::ut::Color4f m_BarColor;
    nw::ut::Color4f m_OverflowBarColor;

#if defined(NW_DEBUG)
public:
    /*override*/ const char* ToString() const
    {
        return "PeakMeter";
    }
#endif
};

} // snd
} // nw
