﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <controls/ParameterListView.h>
#include <controls/SelectableParameterListItem.h>
#include <controls/F32ParameterListItem.h>
#include <models/PreviewEffect.h>

#if defined(NW_SND_CONFIG_ENABLE_MULTICHEFT)

namespace nw {
namespace snd {

class MultiChReverbParameterListView : public ParameterListView<PreviewEffectMultiChReverb, 16>
{
public:
    MultiChReverbParameterListView();

private:
    SelectableParameterListItem<PreviewEffectMultiChReverb, u32> m_EarlyModeControl;
    SelectableParameterListItem<PreviewEffectMultiChReverb, u32> m_LateModeControl;
    F32ParameterListItem<PreviewEffectMultiChReverb> m_PreDelayTimeControl;
    F32ParameterListItem<PreviewEffectMultiChReverb> m_DecayTimeControl;
    F32ParameterListItem<PreviewEffectMultiChReverb> m_HfDecayRatioControl;
    F32ParameterListItem<PreviewEffectMultiChReverb> m_ColorationControl;
    F32ParameterListItem<PreviewEffectMultiChReverb> m_EarlyGainControl;
    F32ParameterListItem<PreviewEffectMultiChReverb> m_LateGainControl;
    F32ParameterListItem<PreviewEffectMultiChReverb> m_ReverbGainControl;

#if defined(NW_DEBUG)
public:
    /*override*/ const char* ToString() const
    {
        return "MultiChReverbParameterListView";
    }
#endif
};

} // snd
} // nw

#endif
