﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <controls/ParameterListView.h>
#include <controls/F32ParameterListItem.h>
#include <controls/SelectableParameterListItem.h>
#include <models/PreviewEffect.h>

#if defined(NW_SND_CONFIG_ENABLE_MULTICHEFT)

namespace nw {
namespace snd {

class MultiChChorusParameterListView : public ParameterListView<PreviewEffectMultiChChorus, 16>
{
public:
    MultiChChorusParameterListView();

private:
    F32ParameterListItem<PreviewEffectMultiChChorus> m_DelayTimeControl;
    F32ParameterListItem<PreviewEffectMultiChChorus> m_DepthControl;
    F32ParameterListItem<PreviewEffectMultiChChorus> m_RateControl;
    F32ParameterListItem<PreviewEffectMultiChChorus> m_FeedbackControl;
    F32ParameterListItem<PreviewEffectMultiChChorus> m_OutGainControl;

#if defined(NW_DEBUG)
public:
    /*override*/ const char* ToString() const
    {
        return "MultiChChorusParameterListView";
    }
#endif
};

} // snd
} // nw

#endif
