﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/dw/dw_Controls.h>
#include <models/PreviewEffectSet.h>
#include <controls/ReverbHiParameterListView.h>
#include <controls/ReverbStdParameterListView.h>
#include <controls/ChorusParameterListView.h>
#include <controls/DelayParameterListView.h>
#if defined(NW_SND_CONFIG_ENABLE_MULTICHEFT)
#include <controls/MultiChReverbParameterListView.h>
#include <controls/MultiChChorusParameterListView.h>
#include <controls/MultiChDelayParameterListView.h>
#endif

namespace nw {
namespace snd {

class EffectParametersView : public nw::internal::dw::UIElement
{
private:
    static const u32 EFFECT_LABEL_SIZE = 32;

public:
    EffectParametersView();

public:
    void SetModel(PreviewEffectSet* pEffectSet, s32 ausBusIndex, s32 effectIndex);

protected:
    /* override */ void OnUpdate(const nw::internal::dw::UIElementTreeContext& context);

private:
    nw::internal::dw::UIElement* GetParametersView();

private:
    PreviewEffectSet* m_pEffectSet;
    s32 m_AusBusIndex;
    s32 m_EffectIndex;

    nw::internal::dw::FixedUIElementList<1> m_Contents;
#if defined(NW_SND_CONFIG_ENABLE_MULTICHEFT)
    nw::internal::dw::FixedDockPanel<9> m_Container;
#else
    nw::internal::dw::FixedDockPanel<6> m_Container;
#endif

    nw::internal::dw::FixedLabel<EFFECT_LABEL_SIZE> m_EffectLabel;
    nw::internal::dw::FixedLabel<16> m_NoParametersLabel;
    ReverbHiParameterListView m_ReverbHiParameterListView;
    ReverbStdParameterListView m_ReverbStdParameterListView;
    ChorusParameterListView m_ChorusParameterListView;
    DelayParameterListView m_DelayParameterListView;
#if defined(NW_SND_CONFIG_ENABLE_MULTICHEFT)
    MultiChReverbParameterListView m_MultiChReverbParameterListView;
    MultiChChorusParameterListView m_MultiChChorusParameterListView;
    MultiChDelayParameterListView m_MultiChDelayParameterListView;
#endif

#if defined(NW_DEBUG)
public:
    /*override*/ const char* ToString() const
    {
        return "EffectParametersView";
    }
#endif
};

} // snd
} // nw
