﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once
// AnimSoundをコントロールするクラス。

#include <nw/snd.h>
#include <anim/AnimSoundFileBuffer.h>
#include <anim/RingBuffer.h>

namespace nw {
namespace snd {

struct AnimSoundModifyInfo
{
    u32 soundID;
    char* soundName;
    u8 volume;
    f32 pitch;
    s32 startFrame;
    s32 endFrame;
    u8 frameFlag;
    s8 loopOffset;
    u8 loopInterval;
    u8 playDirection;
    u8 sequenceVariableNo;
};

class AnimSoundController
{
public:
    AnimSoundController();
    ~AnimSoundController();

    bool Initialize(ut::IAllocator* allocator, SoundArchivePlayer& player);
    void Finalize();
    bool IsAvailable() const;
    void SetEnabled(bool enabled);
    void LoadSoundId();

    void StopAll();

    bool Load(const char* path, bool isReload);
    void Unload();

    bool Setup();
    void Unsetup();

    //
    void DeleteEvent( s32 id );
    void ModifyEvent( s32 id, const AnimSoundModifyInfo& info );
    void SeekDoEvent(bool doEvent);
    void Looped();
    void UpdateAllEventID(const u16 idList[], u32 listSize);

    void Update();

private:
    AnimSoundFileBuffer* m_CurrentBuffer;
    AnimSound* m_pAnimSound;
    SoundArchivePlayer* m_pPlayer;
    ut::IAllocator* m_Allocator;
    bool m_SeekDoEvent;
    bool m_Looped;
    bool m_IsEnabled;

private:
    // キャッシュ関連
    static const int PATH_MAX = 260;
    struct Cache
    {
        char path[PATH_MAX];
        AnimSound* animSound;
        AnimSoundFileBuffer buffer;
    };

    static const int CACHE_MAX = 16;
    RingBuffer<Cache, CACHE_MAX> m_CacheBuffer;

    Cache* AddCache(const char* path);
    void DeleteCache(Cache* c);
    Cache* SearchCache(const char* path);
};

} // namespace snd
} // namespace nw

//eof
