﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/dev.h>
#include <nw/dw/system/dw_Pointer.h>
#include <nw/dw/control/dw_Canvas.h>
#include <nw/ut/ut_Memory.h>
#if defined(NW_ENABLE_SNDEDIT)
#include <nw/sndedit.h>
#endif
#include <resources/IResourceProvider.h>
#include <models/PreviewSoundArchive.h>
#include <panels/PanelFrame.h>
#include <panels/SoundArchivePlayerPanel.h>
#include <panels/PerformancePanel.h>
#include <panels/MasterOutputPanel.h>
#include <panels/VoicePanel.h>
#if defined(NW_ENABLE_MIDI)
#include <panels/PreviewBankPanel.h>
#endif
#include <panels/cafe/SoundParameterCafePanel.h>
#include <panels/cafe/SoundSystemCafePanel.h>
#include <panels/cafe/WavePreviewCafePanel.h>
#include <panels/cafe/EffectCafePanel.h>
#include <controls/Lamp.h>

namespace nw {
namespace snd {

class IResourceProvider;

//---------------------------------------------------------------------------
//! @brief SoundPlayer のパネル管理クラスです。
//---------------------------------------------------------------------------
class PanelManager
{
private:
    static const s32 INVALID_INDEX = -1;
    static const f32 INVALID_POINTER_POSITION;

public:
    PanelManager();

public:
    void Initialize(IResourceProvider& resourceProvider, nw::ut::IAllocator* allocator);
    void Finalize();

    void UpdateInputs(const nw::dev::Pad* pPad, const nw::dev::Mouse* pMouse);
    void Update(nw::internal::dw::UIElementTreeContext& context, nw::internal::dw::UIRenderer& renderer);
    void Render(nw::internal::dw::UIElementTreeContext& context, nw::internal::dw::UIRenderer& renderer);

    bool IsPanelsVisible() const;

    PreviewEffectManager* CurrentPreviewEffectManager();
    void SetEffectDevice(u32 deviceType);

private:
    bool PreUpdateInputs(const nw::dev::Pad& pad);

    void DrawMousePointer(nw::internal::dw::UIRenderer& renderer);

private:
    s32 m_ActivePanelFrameIndex;
    bool m_IsPanelsVisible;

    nw::internal::dw::Canvas m_RootElement;
    nw::internal::dw::FixedUIElementList<32> m_RootContents;

    PanelFrame<SoundArchivePlayerPanel> m_SoundArchivePlayerPanelFrame;
    PanelFrame<SoundParameterCafePanel> m_SoundParameterPanelFrame;
    PanelFrame<PerformancePanel> m_PerformancePanelFrame;
    PanelFrame<MasterOutputPanel> m_MasterOutputPanelFrame;
    PanelFrame<VoicePanel> m_VoicePanelFrame;
    PanelFrame<EffectCafePanel> m_EffectPanelFrame;
#if defined(NW_PLATFORM_CAFE) || defined(NW_ENABLE_SSMODE)
    PanelFrame<SoundSystemCafePanel> m_SoundSystemPanelFrame;
#else
    PanelFrame<SoundSystemPanel> m_SoundSystemPanelFrame;
#endif
    PanelFrame<WavePreviewCafePanel> m_WavePreviewPanelFrame;
#if defined(NW_ENABLE_MIDI)
    PanelFrame<PreviewBankPanel> m_PreviewBankPanelFrame;
#endif

#if defined(NW_SND_EDIT_USE_MCS)
    Lamp m_McsConnectionLamp;
#endif
    Lamp m_RenderingModeLamp;
#if defined(NW_ENABLE_SNDEDIT)
    Lamp m_EditEnabledLamp;
#endif

    nw::internal::dw::detail::Pointer m_MousePointer;

#if defined(NW_ENABLE_SNDEDIT)
    edit::SoundEditSession* m_pSoundEditSession;
#endif
};

} // nw::snd
} // nw
