﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NintendoWare.SoundMaker
{
    using NintendoWare.SoundMakerPlugin;
    using Runtime = NintendoWare.SoundRuntime;

    public class SequenceSoundPlayerGeneric : ISequenceSoundPlayer
    {
        private Runtime.SequenceSoundPlayerCafe seqPlayer;

        public SequenceSoundPlayerGeneric()
        {
            this.seqPlayer = new Runtime.SequenceSoundPlayerCafe();
        }

        public void Initialize()
        {
            this.seqPlayer.Initialize();
        }

        public void Setup(uint allocTrackFlag, RuntimeNoteOnCallback noteOnCallback, object userData)
        {
            Runtime.NoteOnCallback callback = (IntPtr seqPlayer, int bankNo, ref Runtime.NoteOnInfo noteOnInfo, object uData) =>
                {
                    IRuntimeNoteOnInfo rnoInfo = new RuntimeNoteOnInfo(noteOnInfo);
                    Runtime.ChannelCafe ch = (Runtime.ChannelCafe)noteOnCallback(seqPlayer, bankNo, ref rnoInfo, uData);
                    noteOnInfo = (rnoInfo as RuntimeNoteOnInfo).NoteOnInfo;
                    return ch;
                };

            this.seqPlayer.Setup(allocTrackFlag, callback, userData);
        }

        public void ForceTrackMute(uint trackMask)
        {
            this.seqPlayer.ForceTrackMute(trackMask);
        }

        public short GetLocalVariable(int varNo)
        {
            return this.seqPlayer.GetLocalVariable(varNo);
        }

        public short GetTrackVariable(int trackNo, int varNo)
        {
            return this.seqPlayer.GetTrackVariable(trackNo, varNo);
        }

        public void SetSeqData(IntPtr seq, IntPtr[] banks, IntPtr[] warcs, bool[] warcsIsIndividuals, int seqOffset)
        {
            this.seqPlayer.SetSeqData(seq, banks, warcs, warcsIsIndividuals, seqOffset);
        }

        public void SetVolume(float volume)
        {
            this.seqPlayer.SetVolume(volume);
        }

        public void SetChannelPriority(int prio)
        {
            this.seqPlayer.SetChannelPriority(prio);
        }

        public void SetLocalVariable(int varNo, short var)
        {
            this.seqPlayer.SetLocalVariable(varNo, var);
        }

        public void SetTrackVariable(int trackNo, int varNo, short var)
        {
            this.seqPlayer.SetTrackVariable(trackNo, varNo, var);
        }

        public bool IsActive()
        {
            return this.seqPlayer.IsActive();
        }

        public bool IsPause()
        {
            return this.seqPlayer.IsPause();
        }

        public bool IsPlayFinished()
        {
            return this.seqPlayer.IsPlayFinished();
        }

        public void Pause(bool flag)
        {
            this.seqPlayer.Pause(flag);
        }

        public void Start()
        {
            this.seqPlayer.Start();
        }

        public void Stop()
        {
            this.seqPlayer.Stop();
        }
    }
}
