﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

// stdafx.h : 標準のシステム インクルード ファイルのインクルード ファイル、または
// 参照回数が多く、かつあまり変更されない、プロジェクト専用のインクルード ファイル
// を記述します。

#pragma once

// #include "targetver.h"

#ifndef WIN32_LEAN_AND_MEAN
#define WIN32_LEAN_AND_MEAN
#endif
#ifndef NOMINMAX
#define NOMINMAX
#endif
// Windows ヘッダー ファイル:
#include <windows.h>

#include <mmsystem.h>
#include <process.h>
#include <cassert>

#define NW_DEV_DISABLED

//#include <winext/cafe.h>

// NOTE:
// C++/CLI は <atomic> をサポートしていないので <atomic> をインクルードしないように、
// 必要な最小限のヘッダのみをインクルードします。

// NN_AUDIO_ALIGNAS_BUFFER_ALIGN (=__declspec(align(64))) がマネージドコードでビルドエラーとなるため pragma で回避
#pragma managed(push, off)
//#include <nn/atk.h>
#include <nn/atk/atk_Config.h>

#include <nn/atk/atk_Channel.h>
#include <nn/atk/atk_MidiSequencePlayer.h>
#include <nn/atk/atk_MidiSequenceTrack.h>
#include <nn/atk/atk_MidiSequenceTrackAllocator.h>
#include <nn/atk/atk_MmlSequenceTrack.h>
#include <nn/atk/atk_MmlSequenceTrackAllocator.h>
#include <nn/atk/atk_SequenceSound.h>
#include <nn/atk/atk_SequenceSoundFileReader.h>
#include <nn/atk/atk_SequenceSoundPlayer.h>
#include <nn/atk/atk_SoundSystem.h>
#pragma managed(pop)

//#include <nw/snd.h>
//#include <nw/types.h>
//#include <nw/dev.h>

#undef DEFAULT_PITCH        // snd_BankFile.cpp や snd_WaveSoundFile.cpp で定義されているが、
                            // WinGDI.h でも定義されているため、コンパイルエラーを引き起こす。

#include <list>
