﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "smfconv.h"
#include "SmfParser.h"
#include "SmfEvent.h"

void test()
{

    // convKey2String
    {
        assert(convKey2String(0) == "cnm1");
        assert(convKey2String(60) == "cn4");
        assert(convKey2String(61) == "cs4");
    }


    // ノートコマンドの比較
    {
        NoteEvent note1(1000, 60, 127);
        NoteEvent note2(1000, 60, 127);
        NoteEvent note3(1000, 60, 120);
        NoteEvent note4(1000, 20, 127);
        ProgramChangeEvent prg(1000, 2);

        note1.noteOff(1200);
        note2.noteOff(1300);
        note3.noteOff(1200);
        note4.noteOff(1200);
        assert(note1.isEqual(&note1));
        assert(!note1.isEqual(&note2));
        assert(!note1.isEqual(&note3));
        assert(!note1.isEqual(&note4));
        assert(!note1.isEqual(&prg));
    }

    // プログラムチェンジの比較
    {
        ProgramChangeEvent prg1(1000, 2);
        ProgramChangeEvent prg2(1200, 2);
        ProgramChangeEvent prg3(1000, 3);

        assert(prg1.isEqual(&prg1));
        assert(prg1.isEqual(&prg2));
        assert(!prg1.isEqual(&prg3));
    }
}

