﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <sndlib/endian.h>
#include <sndlib/lexer.h>
#include <sndlib/cmdline.h>

void print_usage();

struct CommandLineArg
{
    CommandLineArg()
    : update_flag(false),
      verbose_flag(false),
      help_flag(false)
    {
    }

    void AppendSearchPath( sndlib::Lexer& lexer ) {
        for( SearchPathList_t::const_iterator p = searchPath.begin() ;
             p != searchPath.end() ; p++ )
        {
            lexer.PushSearchPath( *p );
        }
    }

    typedef std::vector<std::string> FileList_t;
    typedef std::vector<std::string> SearchPathList_t;

    FileList_t files;
    SearchPathList_t searchPath;
    bool update_flag;
    bool verbose_flag;
    bool help_flag;
    std::string out_file;
};

class MyCommandLineArgParser : public sndlib::CommandLineArgParser
{
  public:
    MyCommandLineArgParser( CommandLineArg& arg )
    : mArg( arg )
    {
        AddOption("h");
        AddOption("help");
        AddOption("u");
        AddOption("update");
        AddOption("v");
        AddOption("verbose");
        AddOptionWithArg("o");
        AddOptionWithArg("I");
    }

  protected:
    virtual void OptionHandler( std::string opt, std::string arg )
    {
        if ( opt == "help" || opt == "h" ) { mArg.help_flag = true; }
        else if ( opt == "update" || opt == "u" ) { mArg.update_flag = true; }
        else if ( opt == "verbose" || opt == "v" ) { mArg.verbose_flag = true; }
        else if ( opt == "o" ) { mArg.out_file = arg; }
        else if ( opt == "I" ) { mArg.searchPath.push_back( arg ); }
    }
    virtual void ArgHandler( std::string arg )
    {
        mArg.files.push_back( arg );
    }

  private:
    CommandLineArg& mArg;
};

class my_exception : public std::exception {
  public:
    explicit my_exception(const std::string& _S)
    : exception(""), _Str(_S) {}
    virtual const char *what() const
    {return (_Str.c_str()); }
  private:
    std::string _Str;
};
