﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Configuration;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Text;

// MEFを使うには以下の2つが必要です。
// 参照設定にもSystem.ComponentModel.Compositionを追加する必要があります。
using System.ComponentModel.Composition;
using System.ComponentModel.Composition.Hosting;

namespace NintendoWare.SoundMaker
{
    // 参照設定に、SoundMakerPlugin を含める必要があります。
    using NintendoWare.SoundMakerPlugin;

    using NintendoWare.SoundFoundation;
    using NintendoWare.SoundFoundation.Conversion;
    using NintendoWare.SoundFoundation.Conversion.NintendoWareBinary;
    using NintendoWare.SoundFoundation.Documents;
    using NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary;
    using NintendoWare.SoundFoundation.Projects;
    using NintendoWare.SoundMaker.FileFormats;
    using NintendoWare.SoundMaker.Framework.Preview.Communications;
    using NintendoWare.SoundMaker.Preview.Communications;
    using NintendoWare.SoundMaker.Preview.MCS;
    using NintendoWare.SoundMaker.Resources;

    [Export(typeof(ISoundMakerPlugin))]
    public class SoundMakerPluginCafe : ISoundMakerPlugin
    {
        private AppSettingsSection appSettings;
        [Import("NintendoWare.SoundMaker.SoundMakerPluginGeneric")]
        private ISoundMakerPlugin SoundMakerGeneric = null;
        private IDocumentFactory[] documentFactories;
        private IDocumentReader[] documentReaders;
        private CommunicationInfo communicationInfo;
        private MCSManager commManager;
        private TargetPlayerCafe targetPlayerCafe;

        public SoundMakerPluginCafe()
        {
            Configuration config = ConfigurationManager.OpenExeConfiguration(this.GetType().Assembly.Location);
            this.appSettings = (AppSettingsSection)config.GetSection("appSettings");
            this.communicationInfo = new CommunicationInfo((this as ISoundMakerPlugin).Platform);
            this.CommunicationInfoInitialize();
            this.targetPlayerCafe = new TargetPlayerCafe(this.SoundPlayerDirectory, this.SoundPlayerContentsDirectory);
        }

        string ISoundMakerPlugin.Platform
        {
            get
            {
                return "Cafe";
            }
        }

        // Preview

        // Runtime.SoundSystemCafe

        int ISoundMakerPlugin.RuntimeSoundSystem_GetActiveVoiceCount()
        {
            return this.SoundMakerGeneric.RuntimeSoundSystem_GetActiveVoiceCount();
        }

        void ISoundMakerPlugin.RuntimeSoundSystem_LockSoundThread()
        {
            this.SoundMakerGeneric.RuntimeSoundSystem_LockSoundThread();
        }

        void ISoundMakerPlugin.RuntimeSoundSystem_UnlockSoundThread()
        {
            this.SoundMakerGeneric.RuntimeSoundSystem_UnlockSoundThread();
        }

        void ISoundMakerPlugin.RuntimeSoundSystem_StopAllVoices()
        {
            this.SoundMakerGeneric.RuntimeSoundSystem_StopAllVoices();
        }

        void ISoundMakerPlugin.RuntimeSoundSystem_SoundThreadPause(bool pauseFlag)
        {
            this.SoundMakerGeneric.RuntimeSoundSystem_SoundThreadPause(pauseFlag);
        }

        void ISoundMakerPlugin.RuntimeSoundSystem_SoundFrameProcess()
        {
            this.SoundMakerGeneric.RuntimeSoundSystem_SoundFrameProcess();
        }

        void ISoundMakerPlugin.RuntimeSoundSystem_InitSoundSystem(int soundThreadPriority, int dvdThreadPriority)
        {
            this.SoundMakerGeneric.RuntimeSoundSystem_InitSoundSystem(soundThreadPriority, dvdThreadPriority);
        }

        void ISoundMakerPlugin.RuntimeSoundSystem_ShutdownSoundSystem()
        {
            this.SoundMakerGeneric.RuntimeSoundSystem_ShutdownSoundSystem();
        }

        bool ISoundMakerPlugin.IsNwRendererEnabled
        {
            get { return true; }
        }

        // Runtime.Global

        int ISoundMakerPlugin.RuntimeGlobal_DefaultSampleRate
        {
            get { return 32000;  }
        }

        int ISoundMakerPlugin.RuntimeGlobal_CHANNEL_COUNT
        {
            get
            {
                return this.SoundMakerGeneric.RuntimeGlobal_CHANNEL_COUNT;
            }
        }

        int ISoundMakerPlugin.RuntimeGlobal_MSEC_PER_FRAME
        {
            get
            {
                return this.SoundMakerGeneric.RuntimeGlobal_MSEC_PER_FRAME;
            }
        }

        int ISoundMakerPlugin.RuntimeGlobal_AXSynthesize(short[] buffer, int samplingRate)
        {
            return this.SoundMakerGeneric.RuntimeGlobal_AXSynthesize(buffer, samplingRate);
        }

        void ISoundMakerPlugin.InitializeAudioDevice(string deviceName)
        {
            this.SoundMakerGeneric.InitializeAudioDevice(deviceName);
        }

        void ISoundMakerPlugin.RuntimeGlobal_AXInit()
        {
            this.SoundMakerGeneric.RuntimeGlobal_AXInit();
        }

        void ISoundMakerPlugin.RuntimeGlobal_AXQuit()
        {
            this.SoundMakerGeneric.RuntimeGlobal_AXQuit();
        }

        IEnumerable<string> ISoundMakerPlugin.EnumerateAudioDeviceNames()
        {
            return this.SoundMakerGeneric.EnumerateAudioDeviceNames();
        }

        // Runtime.SequenceSoundPlayerCafe

        short ISoundMakerPlugin.RuntimeSequenceSoundPlayer_GetGlobalVariable(int varNo)
        {
            return this.SoundMakerGeneric.RuntimeSequenceSoundPlayer_GetGlobalVariable(varNo);
        }

        void ISoundMakerPlugin.RuntimeSequenceSoundPlayer_SetGlobalVariable(int varNo, short var)
        {
            this.SoundMakerGeneric.RuntimeSequenceSoundPlayer_SetGlobalVariable(varNo, var);
        }

        // Create

        IPreviewSequenceChannel ISoundMakerPlugin.CreatePreviewSequenceChannel(string bankFileName, Instrument instrument, ref IRuntimeNoteOnInfo noteOnInfo)
        {
            return this.SoundMakerGeneric.CreatePreviewSequenceChannel(bankFileName, instrument, ref noteOnInfo);
        }

        IPreviewSequenceChannel ISoundMakerPlugin.CreatePreviewSequenceChannel(string bankFileName, ref IRuntimeNoteOnInfo noteOnInfo, RendererType rendererType)
        {
            return this.SoundMakerGeneric.CreatePreviewSequenceChannel(bankFileName, ref noteOnInfo, rendererType);
        }

        IPreviewWaveChannel ISoundMakerPlugin.CreatePreviewWaveChannel(WaveSoundBase sound, RendererType rendererType, bool forceNoLoop)
        {
            return this.SoundMakerGeneric.CreatePreviewWaveChannel(sound, rendererType, forceNoLoop);
        }

        IPreviewStreamChannel ISoundMakerPlugin.CreatePreviewStreamChannel(
            StreamSoundTrackBase streamTrack,
            StreamSoundTrackBase baseTrack,
            int channelIndexStart,
            float volume,
            float pitch,
            PanMode panMode,
            PanCurve panCurve,
            float mainSend,
            RendererType rendererType,
            bool forceNoLoop)
        {
            return this.SoundMakerGeneric.CreatePreviewStreamChannel(streamTrack, baseTrack, channelIndexStart, volume, pitch, panMode, panCurve, mainSend, rendererType, forceNoLoop);
        }

        ISequenceSoundPlayer ISoundMakerPlugin.CreateSequenceSoundPlayer()
        {
            return this.SoundMakerGeneric.CreateSequenceSoundPlayer();
        }

        ISeqFileReader ISoundMakerPlugin.CreateSeqFileReader(IntPtr seqData)
        {
            return this.SoundMakerGeneric.CreateSeqFileReader(seqData);
        }

        ISequenceSoundBinaryReader ISoundMakerPlugin.CreateSequenceSoundBinaryReader()
        {
            return this.SoundMakerGeneric.CreateSequenceSoundBinaryReader();
        }

        IMidiManager ISoundMakerPlugin.CreateMidiManager()
        {
            return this.SoundMakerGeneric.CreateMidiManager();
        }


        // Converter 関連

        CreateSoundProjectConverterDelegate ISoundMakerPlugin.GetCreateSoundProjectConverterDelegate()
        {
            return this.SoundMakerGeneric.GetCreateSoundProjectConverterDelegate();
        }

        CreateSoundIDCppHeaderExporterDelegate ISoundMakerPlugin.GetCreateSoundIDCppHeaderExporterDelegate()
        {
            return this.SoundMakerGeneric.GetCreateSoundIDCppHeaderExporterDelegate();
        }

        CreateFileIDAggregateFactoryDelegate ISoundMakerPlugin.GetCreateFileIDAggregateFactoryDelegate()
        {
            return this.SoundMakerGeneric.GetCreateFileIDAggregateFactoryDelegate();
        }

        CreateFileIDDelegate ISoundMakerPlugin.GetCreateFileIDDelegate()
        {
            return this.SoundMakerGeneric.GetCreateFileIDDelegate();
        }

        CreateSoundArchiveBinaryXmlDelegate ISoundMakerPlugin.GetCreateSoundArchiveBinaryXmlDelegate()
        {
            return this.SoundMakerGeneric.GetCreateSoundArchiveBinaryXmlDelegate();
        }

        CreateWaveFileInfoDelegate ISoundMakerPlugin.GetCreateWaveFileInfoDelegate()
        {
            return this.SoundMakerGeneric.GetCreateWaveFileInfoDelegate();
        }

        CreateSoundArchiveBinaryMapExporterDelegate ISoundMakerPlugin.GetCreateSoundArchiveBinaryMapExporterDelegate()
        {
            return this.SoundMakerGeneric.GetCreateSoundArchiveBinaryMapExporterDelegate();
        }

        // 接続関連
        CommunicationInfo ISoundMakerPlugin.CommunicationInfo
        {
            get
            {
                return this.communicationInfo;
            }
        }

        private void CommunicationInfoInitialize()
        {
            this.commManager = new MCSManager();
            this.commManager.Initialize(null, new MCSConsole());

            ConnectionInfo[] connectionInfos =
                {
                    new ConnectionInfo("WiiUApplication", MessageResource.WiiUApplication, true, this.Connect, this.Disconnect, this.IsConnected, this.IsConnecting, this.IsConnectedSndEdit, this.IsConnectingSndEdit, this.GetState, this.commManager),
                    new ConnectionInfo("WiiUSoundPlayer", MessageResource.WiiUSoundPlayer, true, this.Connect, this.Disconnect, this.IsConnected, this.IsConnecting, this.IsConnectedSndEdit, this.IsConnectingSndEdit, this.GetState, this.commManager),
#if USE_NWSND
                    new ConnectionInfo("PCApplication_nwsnd", MessageResource.PCApplication_nwsnd, false, null, null, null, null, null, null, null, null),
#endif
#if USE_PCSOUNDPLAYER
                    new ConnectionInfo("PCSoundPlayer_nwsnd", MessageResource.PCSoundPlayer_nwsnd, false, null, null, null, null, null, null, null, null),
#endif
                };

            foreach (ConnectionInfo info in connectionInfos)
            {
                this.communicationInfo.SetConnectionInfo(info.TargetName, info);
            }
        }

        private bool Connect(object param)
        {
            Debug.WriteLine("Plugin Cafe Connect");

            return this.commManager.Connect();
        }

        private void Disconnect()
        {
            Debug.WriteLine("Plugin Cafe Disconnect");

            this.commManager.Disconnect();
        }

        private bool IsConnected()
        {
            Debug.WriteLine("Plugin Cafe IsConnected");

            return this.commManager.IsConnected;
        }

        private bool IsConnecting()
        {
            Debug.WriteLine("Plugin Cafe IsConnecting");

            return this.commManager.IsConnecting;
        }

        private bool IsConnectedSndEdit()
        {
            Debug.WriteLine("Plugin Cafe IsConnectedSndEdit");

            return this.commManager.IsConnectedSndEdit;
        }

        private bool IsConnectingSndEdit()
        {
            Debug.WriteLine("Plugin Cafe IsConnectingSndEdit");

            return this.commManager.IsConnectingSndEdit;
        }

        private ConnectionState GetState()
        {
            Debug.WriteLine("Plugin Cafe GetState");

            return this.commManager.GetState();
        }


        // その他
        void ISoundMakerPlugin.Initialize(SoundSetComponentFactory soundSetComponentFactory)
        {
            this.documentFactories = new IDocumentFactory[]{};
            this.documentReaders = new IDocumentReader[]{};
        }

        IEnumerable<IDocumentFactory> ISoundMakerPlugin.DocumentFactories
        {
            get { return this.documentFactories; }
        }

        IEnumerable<IDocumentReader> ISoundMakerPlugin.DocumentReaders
        {
            get { return this.documentReaders; }
        }

        string ISoundMakerPlugin.GetExpandedAppSetting(string key)
        {
            if (this.appSettings.Settings.AllKeys.Contains(key) == false)
            {
                return string.Empty;
            }

            return this.ExpandMacro(this.appSettings.Settings[key].Value);
        }

        // コントロール関係
        string ISoundMakerPlugin.PlatformLabel
        {
            get
            {
                return "Wii U";
            }
        }

        bool ISoundMakerPlugin.IsValidateWaveEncodingValue(WaveEncoding encoding)
        {
            switch (encoding)
            {
            case WaveEncoding.Pcm8:
            case WaveEncoding.Pcm16:
            case WaveEncoding.Adpcm:
            case WaveEncoding.NoConvert:
                return true;

            default:
                return false;
            }
        }

        // SoundPlayer 関係
        ITargetPlayer ISoundMakerPlugin.TargetPlayer
        {
            get
            {
                return this.targetPlayerCafe;
            }
        }

        private string SoundPlayerDirectory
        {
            get
            {
                return (this as ISoundMakerPlugin).GetExpandedAppSetting("SoundPlayerDirectory");
            }
        }

        private string SoundPlayerContentsDirectory
        {
            get
            {
                return (this as ISoundMakerPlugin).GetExpandedAppSetting("SoundPlayerContentsDirectory");
            }
        }

        private string ExpandMacro(string value)
        {
            {
                string executingDirectory = Path.GetFullPath(Path.GetDirectoryName(Assembly.GetEntryAssembly().Location));
                value = value.Replace("$(SoundMakerDirectory)", executingDirectory);
            }
            return value;
        }

        //////
#if DEBUG
        string ISoundMakerPlugin.GetMessage()
        {
            return "SoundMaker Cafe !!";
        }
#endif
    }
}
