﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Runtime.InteropServices;

namespace NintendoWare.SoundFoundation.Legacies.FileFormat
{
    /// <summary>
    /// Win32 の概要の説明です。
    /// </summary>
    public class Win32
    {
        public const uint FILE_FLAG_OVERLAPPED = 0x40000000;
        public static readonly IntPtr INVALID_HANDLE_VALUE = new IntPtr(-1);

        public const int WM_COPYDATA = 0x004A;

        [StructLayout(LayoutKind.Sequential)]
        public struct COPYDATASTRUCT
        {
            public uint dwData;
            public uint cbData;
            public IntPtr lpData;
        }

        [DllImport("kernel32.dll")]
        public extern static long CloseHandle(IntPtr handle);

        [DllImport("User32.dll", EntryPoint = "SendMessage")]
        public static extern IntPtr SendMessage_CopyData(IntPtr hWnd, uint msg, IntPtr wParam, ref COPYDATASTRUCT cds);


        [StructLayout(LayoutKind.Sequential)]
        public struct WAVEOUTCAPS
        {
            public ushort wMid;
            public ushort wPid;
            public uint vDriverVersion;
            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 32)]
            public string strPname;
            public uint dwFormats;
            public ushort wChannels;
            public ushort wReserved1;
            public uint dwSupport;
        };

        [DllImport("winmm.dll")]
        public extern static uint waveOutGetNumDevs();
        [DllImport("winmm.dll")]
        public extern static uint waveOutGetDevCaps(uint uDeviceID, out WAVEOUTCAPS pwoc, uint cbwoc);

        [StructLayout(LayoutKind.Sequential)]
        public struct MIDIINCAPS
        {
            public ushort wMid;
            public ushort wPid;
            public uint vDriverVersion;
            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 32)]
            public string strPname;
            public uint dwSupport;
        };

        [DllImport("winmm.dll")]
        public extern static uint midiInGetNumDevs();
        [DllImport("winmm.dll")]
        public extern static uint midiInGetDevCaps(uint uDeviceID, out MIDIINCAPS pmic, uint cbmic);
    }
}
