﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.IO;
using System.Xml;

// TODO: Nw4rSoundSetに依存しているので、WaveSoundSet用のコードを書く必要がある

namespace NintendoWare.SoundFoundation.Legacies.FileFormat.Nw4rFileFormat
{

    public class Nw4rXmlWaveSoundSet : Nw4rXmlFile
    {
        Nw4rSoundSetWaveSoundSet wsd;

        public Nw4rSoundSetWaveSoundSet WaveSoundSet
        {
            set { wsd = value; }
            get { return wsd; }
        }

        protected override string FileTitle { get { return "NintendoWare Wave Sound Set"; } }

        protected override void LoadBody(XmlDocument doc, XmlElement bodyElem)
        {
        }
        protected override void SaveBody(XmlDocument doc, XmlElement bodyElem)
        {
            XmlElement waveSoundSetElem = doc.CreateElement("wave_sound_set");

            XmlElement waveSoundArrayElem = doc.CreateElement("wave_sound_array");

            foreach (Nw4rSoundSetWaveSound waveSound in wsd)
            {
                XmlElement waveSoundElem = waveSound.ToXmlElementForWsd(doc, FilePath);
                waveSoundArrayElem.AppendChild(waveSoundElem);
            }

            waveSoundSetElem.AppendChild(waveSoundArrayElem);

            bodyElem.AppendChild(waveSoundSetElem);
        }
    }

}
