﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Text;

using NintendoWare.SoundFoundation.Legacies.FileFormat.Nw4rFileFormat.Model;

namespace NintendoWare.SoundFoundation.Legacies.FileFormat.Nw4rFileFormat
{
    /// <summary>
    /// サウンドアーカイブ IDファイル
    /// </summary>
    internal class Nw4rSoundArchiveIDFile
    {
        #region ** フィールド

        private Nw4rSoundArchive _archive = null;	// サウンドアーカイブ

        #endregion

        public Nw4rSoundArchiveIDFile(Nw4rSoundArchive archive)
        {
            if (null == archive) { throw new Nw4rFileFormatInternalException(new ArgumentNullException("archive")); }
            _archive = archive;
        }

        #region ** メソッド

        public void Write(TextWriter writer)
        {
            if (null == writer) { throw new Nw4rFileFormatInternalException(new ArgumentNullException("writer")); }

            foreach (Nw4rSound sound in _archive.AllSounds)
            {
                WriteItem(writer, sound.Label, _archive.AllSounds.IndexOf(sound.Key));
            }

            foreach (Nw4rBank bank in _archive.AllBanks)
            {
                WriteItem(writer, bank.Label, _archive.AllBanks.IndexOf(bank.Key));
            }

            foreach (Nw4rPlayer player in _archive.AllPlayers)
            {
                WriteItem(writer, player.Label, _archive.AllPlayers.IndexOf(player.Key));
            }

            foreach (Nw4rGroup group in _archive.AllGroups)
            {
                if (0 == group.Label.Length) { continue; }
                WriteItem(writer, group.Label, _archive.AllGroups.IndexOf(group.Key));
            }
        }

        private void WriteItem(TextWriter writer, string label, int id)
        {
            Debug.Assert(null != writer);
            Debug.Assert(null != label);
            Debug.Assert(0 <= id);

            writer.WriteLine(string.Format("static const unsigned int {0} = {1:D};", label, id));
        }

        #endregion
    }
}
