﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.IO;
using System.Text;

using NintendoWare.SoundFoundation.Legacies.FileFormat.Nw4rFileFormat.Model;

namespace NintendoWare.SoundFoundation.Legacies.FileFormat.Nw4rFileFormat.Converter
{
    internal class Nw4rConvert2StreamXmlCommand : Nw4rConvertCommandT<Nw4rStreamSound, Nw4rSoundIntermediateOutput>
    {
        public Nw4rConvert2StreamXmlCommand(Nw4rStreamSound input, Nw4rSoundIntermediateOutput output)
            : base(input, output) { }

        #region ** プロパティ

        protected override bool ShouldConvert
        {
            get
            {
                try
                {
                    return Output.Dirty;
                }
                catch (DependencyFileNotFoundException exception)
                {
                    throw new Nw4rFileNotFoundException(exception.FileName, Input.Label);
                }
            }
        }

        #endregion

        #region ** イベントハンドラ

        protected override void OnInvoke()
        {
            // 出力ディレクトリの生成
            CreateDirectory(Path.GetDirectoryName(Output.File.FilePath), Input.Label);

            Nw4rXmlStrmSoundStrm xmlStreamSound = new Nw4rXmlStrmSoundStrm(Input.XmlData.Label);

            foreach (Nw4rSoundSetStrm.Track track in Input.XmlData.TrackList)
            {

                Nw4rXmlStrmSoundStrm.Track xmlTrack = new Nw4rXmlStrmSoundStrm.Track();
                xmlTrack.Index = track.Index;
                xmlTrack.FileFormat = track.FileFormat;
                xmlTrack.FullPath = track.FullPath;
                xmlTrack.Pan = track.Pan;
                xmlTrack.Volume = track.Volume;

                xmlStreamSound.TrackList.Add(xmlTrack);

            }

            xmlStreamSound.TrackList.Sort(Nw4rXmlStrmSoundStrm.CompareTrackByIndex);


            Nw4rXmlStrmSound xmlFile = new Nw4rXmlStrmSound();
            xmlFile.GeneratorName = (Input.Parent as Model.Nw4rSoundSet).XmlData.GeneratorName;
            xmlFile.GeneratorVersion = (Input.Parent as Model.Nw4rSoundSet).XmlData.GeneratorVersion;
            xmlFile.StrmSoundData = xmlStreamSound;

            xmlFile.Save(Output.File.FilePath);
        }

        protected override void OnClean()
        {
            try
            {
                File.Delete(Output.File.FilePath);
            }
            catch (Exception)
            {
            }
        }

        #endregion
    }
}
