﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections;
using System.Diagnostics;
using System.IO;
using System.Text;
using System.Threading;

using NintendoWare.SoundFoundation.Legacies.FileFormat.Nw4rFileFormat.Model;

namespace NintendoWare.SoundFoundation.Legacies.FileFormat.Nw4rFileFormat.Converter
{
    internal class Nw4rConvert2SequenceXmlCommand : Nw4rConvertCommandT<Nw4rSequenceSound, Nw4rSoundIntermediateOutput>
    {
        #region ** 固定値

        private static readonly string ConverterFileName = "nw4r_smfconv.exe";
        private static readonly string ConvertOption_OUTPUT = "-o ";
        private static readonly string ConvertOption_TIMEBASE = "--timebase ";

        private int _timebase = 48;

        #endregion

        public Nw4rConvert2SequenceXmlCommand(Nw4rSequenceSound input, Nw4rSoundIntermediateOutput output)
            : base(input, output) { }

        #region ** プロパティ

        public int TimeBase
        {
            get { return _timebase; }
            set { _timebase = value; }
        }

        protected override bool ShouldConvert
        {
            get
            {
                try
                {
                    return Output.Dirty;
                }
                catch (DependencyFileNotFoundException exception)
                {
                    throw new Nw4rFileNotFoundException(exception.FileName, Input.Label);
                }
            }
        }

        #endregion

        #region ** イベントハンドラ

        protected override void OnInvoke()
        {
            if (Nw4rSoundSetSeqFileType.Smf != Input.XmlData.FileType) { throw new Nw4rFileFormatInternalException(); }

            // 出力ディレクトリの生成
            CreateDirectory(Path.GetDirectoryName(Output.File.FilePath), Input.Label);

            // 必ず出力されるように UPDATE オプションはつけない
            string commandArgs = string.Empty;

            commandArgs += ConvertOption_TIMEBASE + _timebase.ToString() + " ";

            // 出力ファイルパス
            commandArgs += ConvertOption_OUTPUT + "\"" + Output.File.FilePath + "\" ";

            // 入力ファイルパス
            commandArgs += "\"" + Input.XmlData.FullPath + "\"";

            // テキスト出力
            string converterFilePath = Path.Combine(Nw4rSpecialFolder.CommandLineTools, ConverterFileName);
            OutputLineInternal(new InformationLine(converterFilePath + " " + commandArgs));

            // コンバート処理（処理完了までブロッキング）
            if (!Util.StartProcess(converterFilePath, commandArgs, string.Empty, OnCommandOutput, OnCommandError, ProcessHandler))
            {
                throw new Nw4rCommandException(string.Empty);
            }
        }

        protected override void OnClean()
        {
            Output.OutputItem.Clean();
        }

        private void OnCommandOutput(string message)
        {
            OutputLineInternal(new InformationLine(message));
        }

        private void OnCommandError(string message)
        {
            OutputLineInternal(new ErrorLine(message, Input));
            //throw new Nw4rFileFormatException( message, Input.Label );
        }

        #endregion
    }
}
