﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.ObjectModel;
using System.Diagnostics;
using System.IO;
using System.Text;

using NintendoWare.SoundFoundation.Legacies.Resources;
using NintendoWare.SoundFoundation.Legacies.FileFormat.Nw4rFileFormat.Model;

namespace NintendoWare.SoundFoundation.Legacies.FileFormat.Nw4rFileFormat.Converter
{
    internal class Nw4rConvert2GroupCommand : Nw4rConvertCommandT<Nw4rGroup, Nw4rGroupOutput>
    {
        public Nw4rConvert2GroupCommand(Nw4rGroup input, Nw4rGroupOutput output) : base(input, output) { }

        #region ** プロパティ

        /// <summary>
        /// コンバートする必要がある場合は true、 必要がない場合は false を返します。
        /// </summary>
        protected override bool ShouldConvert
        {
            get
            {
                try
                {
                    return Output.Dirty;
                }
                catch (DependencyFileNotFoundException exception)
                {
                    throw new Nw4rFileNotFoundException(exception.FileName, Input.Label);
                }
            }
        }

        #endregion

        #region ** イベントハンドラ

        protected override void OnInvoke()
        {
            OutputLineInternal(new InformationLine(string.Format(Messages.MessageFormat_Converting, Input.Label)));

            try
            {

                // 出力ディレクトリの生成
                CreateDirectory(Path.GetDirectoryName(Output.File.ARamFilePath), Input.Label);

                // 波形アーカイブファイル
                Nw4rWsdWaveArchiveFile warFile = new Nw4rWsdWaveArchiveFile(Input.BinaryFile.Components);

                using (FileStream stream = File.Open(Output.File.ARamFilePath, FileMode.Create, FileAccess.Write))
                {

                    BinaryWriter writer = BinaryWriterBigEndian.CreateInstance(stream);

                    warFile.Write(writer);
                    writer.Flush();

                }

            }
            catch (FileNotFoundException exception)
            {
                throw new Nw4rFileNotFoundException(exception.FileName, Input.Label);
            }
            catch (DirectoryNotFoundException exception)
            {
                throw new Nw4rFileFormatException(exception.Message, Input.Label);
            }
            catch (UnauthorizedAccessException)
            {
                throw new Nw4rFileAccessDeniedException(Output.File.ARamFilePath, Input.Label);
            }
            catch (PathTooLongException)
            {
                throw new Nw4rFilePathTooLongException(Output.File.ARamFilePath, Input.Label);
            }
        }

        protected override void OnClean()
        {
            Output.OutputItem.Clean();
        }

        #endregion
    }
}
