﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.IO;
using System.Collections;

namespace NintendoWare.SoundFoundation.Legacies.FileFormat.Midi
{

    public class SmfTrack
    {
        SortedList eventList = new SortedList();

        public void AppendEvent(SmfEvent smfEvent)
        {
            eventList.Add(smfEvent.Tick, smfEvent);
        }
    }

    /// <summary>
    /// Smf の概要の説明です。
    /// </summary>
    public class Smf
    {
        SmfHeaderChunk headerChunk = new SmfHeaderChunk();
        TrackCollection trackCollection = new TrackCollection();

        public class TrackCollection
        {
            ArrayList trackList = new ArrayList();

            public int Count
            {
                get { return trackList.Count; }
            }
            public void Add(SmfTrack track)
            {
                trackList.Add(track);
            }
        }

        public class SmfHeaderChunk
        {
            UInt16 format;
            UInt16 trackCount;
            Int16 division;

            public UInt16 Format
            {
                set { format = value; }
                get { return format; }
            }
            public UInt16 TrackCount
            {
                set { trackCount = value; }
                get { return trackCount; }
            }
            public Int16 Division
            {
                set { division = value; }
                get { return division; }
            }
            public void Read(BinaryReader reader)
            {
                format = reader.ReadUInt16();
                trackCount = reader.ReadUInt16();
                division = reader.ReadInt16();
            }
        }

        public SmfHeaderChunk HeaderChunk
        {
            get { return headerChunk; }
        }
        public TrackCollection Tracks
        {
            get { return trackCollection; }
        }
    }

    public class SmfEvent
    {
        ulong tick = 0;

        protected SmfEvent(ulong tick)
        {
            this.tick = tick;
        }
        public ulong Tick
        {
            get { return tick; }
        }
    }

    public class SmfMidiEvent : SmfEvent
    {
        public SmfMidiEvent(ulong tick) : base(tick) { }
    }
    public class SmfMetaEvent : SmfEvent
    {
        public SmfMetaEvent(ulong tick) : base(tick) { }
    }
    public class SmfSysExEvent : SmfEvent
    {
        public SmfSysExEvent(ulong tick) : base(tick) { }
    }

    public class SmfNoteOnEvent : SmfMidiEvent
    {
        public SmfNoteOnEvent(ulong tick) : base(tick) { }
    }
    public class SmfNoteOffEvent : SmfMidiEvent
    {
        public SmfNoteOffEvent(ulong tick) : base(tick) { }
    }
    public class SmfPolyKeyPressureEvent : SmfMidiEvent
    {
        public SmfPolyKeyPressureEvent(ulong tick) : base(tick) { }
    }
    public class SmfControlChangeEvent : SmfMidiEvent
    {
        public SmfControlChangeEvent(ulong tick) : base(tick) { }
    }
    public class SmfProgramChangeEvent : SmfMidiEvent
    {
        public SmfProgramChangeEvent(ulong tick) : base(tick) { }
    }
    public class SmfChannelPressureEvent : SmfMidiEvent
    {
        public SmfChannelPressureEvent(ulong tick) : base(tick) { }
    }
    public class SmfPitchBendEvent : SmfMidiEvent
    {
        public SmfPitchBendEvent(ulong tick) : base(tick) { }
    }

}
