﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Projects
{
    using System.IO;
    using System.Xml.Serialization;
    using NintendoWare.SoundFoundation.Core.IO;
    using NintendoWare.SoundFoundation.Core.Resources;
    using NintendoWare.SoundFoundation.Documents;
    using NintendoWare.SoundFoundation.FileFormats.NintendoWareIntermediate;
    using ToolDevelopmentKit;

    /// <summary>
    /// Ctrサウンドセットドキュメントの書き込みをサポートします。
    /// </summary>
    public class SoundSetDocumentWriterCtr : SoundSetDocumentWriter
    {
        private SoundSetModel2XmlTranslatorCtr translator;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public SoundSetDocumentWriterCtr()
        {
            this.DocumentTypeName = Platforms.Ctr.SoundSetDocument;
            this.DocumentVersion = Platforms.Ctr.SoundSetDocumentVersion;
            this.Platform = Platforms.Ctr.PlatformName;
            this.translator = new SoundSetModel2XmlTranslatorCtr();
        }

        public override void Write(IStreamResource resource, Document document, Document[] documents)
        {
            Ensure.Argument.True(resource is FileResource);
            Ensure.Argument.True(document is SoundSetDocument);

            // ★ヘッダパラメータは仮
            XmlSoundSetFileCtr file = new XmlSoundSetFileCtr()
            {
                Version = this.DocumentVersion,
                Platform = this.Platform,
                Header = new XmlCommonFileHeader()
                {
                    Title = "TestSoundSet",
                },
            };

            translator.PathResolver.BasePath =
                Path.GetDirectoryName(resource.Key.GetFullPath());

            file.Body.SoundSet = translator.Run((document as SoundSetDocument).SoundSet);

            using (Stream stream = File.Open(resource.Key, FileMode.Create, FileAccess.Write, FileShare.None))
            {
                new XmlSerializer(typeof(XmlSoundSetFileCtr)).Serialize(stream, file);
            }
        }
    }
}
