﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Projects
{
    using NintendoWare.SoundFoundation.Core.Parameters;

    public class WaveSoundCtr : WaveSoundBase
    {
        ///--------------------------------
        /// <summary>
        /// パラメータを初期化します。
        /// </summary>
        protected override void InitializeParameters()
        {
            base.InitializeParameters();

            SendsParameterValue sendsParam = new SendsParameterValue(new Sends());
            Parameters.AddValue(ProjectParameterNames.Sound.Sends, sendsParam);

            // ピッチの有効範囲がCTRでは違うので、再登録します。
            // 最大値の 8.0Fは暫定の値になります。(2012/8/24 aoyagi)
            this.Parameters.RemoveValue(ProjectParameterNames.Pitch);
            this.Parameters.AddValue(ProjectParameterNames.Pitch,
                                      new PitchParameterValue(1.0F, 0.00001F, 8.0F));
            this.SetParameterAttributes(ProjectParameterNames.Pitch, ParameterAttributes.ComputeHash);

            // ウェーブサウンドバイナリ依存パラメータ
            this.SetParameterAttributes(ProjectParameterNames.Sound.Sends, ParameterAttributes.ComputeHash);
        }
    }
}
