﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareIntermediate
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Xml;
    using System.Xml.Serialization;
    using ToolDevelopmentKit;

    [Serializable]
    [XmlRoot(
        XmlParameterNamesCtr.CTRParams,
        Namespace = XmlNamespaces.Base,
        IsNullable = false)]
    public class XmlCTRParam : XmlParameter, IXmlParameterProvider
    {
        [XmlArray("Parameters")]
        // CTR パラメータ
        [XmlArrayItem(XmlParameterNamesCtr.CTRParameter.FrontBypass, Type = typeof(XmlFrontBypassParam))]
        public List<XmlParameter> Parameters
        {
            get { return this.XmlValue as List<XmlParameter>; }
            set { this.XmlValue = value; }
        }

        /// <summary>
        /// Name属性は定義しません。
        /// </summary>
        [XmlIgnore]
        public override bool NameSpecified
        {
            get { return false; }
        }

        /// <summary>
        /// 名前を検証し有効化します。
        /// </summary>
        /// <param name="name">名前を指定します。</param>
        /// <returns>有効化された名前を返します。</returns>
        protected override string ValidateName(string name)
        {
            return XmlParameterNamesCtr.CTRParams;
        }

        protected override object ValidateXmlValue(object value)
        {
            Ensure.Argument.True(value is List<XmlParameter>);
            return value;
        }
    }
}
